/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.ancillary.ComponentRegistry;
import org.fujion.annotation.AbstractClassScanner;
import org.fujion.annotation.Component;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.component.BaseComponent;

public class ComponentScanner
extends AbstractClassScanner<BaseComponent, Component> {
    private static final Log log = LogFactory.getLog(ComponentScanner.class);
    private static final ComponentScanner instance = new ComponentScanner();

    public static ComponentScanner getInstance() {
        return instance;
    }

    private ComponentScanner() {
        super(BaseComponent.class, Component.class);
    }

    @Override
    protected void doScanClass(Class<BaseComponent> clazz) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing @Component annotation for class " + clazz));
        }
        ComponentDefinition def = new ComponentDefinition(clazz);
        this.scanMethods(def, clazz, false);
        this.scanMethods(def, def.getFactoryClass(), true);
        ComponentRegistry.getInstance().register(def);
    }

    private void scanMethods(ComponentDefinition def, Class<?> clazz, boolean factoryMethods) {
        if (clazz == Object.class) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            Component.FactoryParameter parameter;
            Component.PropertyGetter getter;
            Component.PropertySetter setter;
            method.setAccessible(true);
            if (method.isSynthetic() || method.isBridge()) continue;
            Component.PropertySetter propertySetter = setter = factoryMethods ? null : method.getAnnotation(Component.PropertySetter.class);
            if (setter != null) {
                def._addSetter(setter, method);
            }
            Component.PropertyGetter propertyGetter = getter = factoryMethods ? null : method.getAnnotation(Component.PropertyGetter.class);
            if (getter != null) {
                def._addGetter(getter, method);
            }
            Component.FactoryParameter factoryParameter = parameter = factoryMethods ? method.getAnnotation(Component.FactoryParameter.class) : null;
            if (parameter == null) continue;
            def._addFactoryParameter(parameter, method);
        }
        this.scanMethods(def, clazz.getSuperclass(), factoryMethods);
    }
}

