/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.List;
import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseUIComponent;
import org.fujion.component.Cell;
import org.fujion.component.MessagePane;
import org.fujion.event.IEventListener;

@Component(tag="messagewindow", widgetClass="Messagewindow", parentTag={"page"}, childTag={@Component.ChildTag(value="messagepane")})
public class MessageWindow
extends BaseUIComponent {
    public void clearMessages() {
        this.destroyChildren();
    }

    public void clearMessages(String category) {
        List<BaseComponent> children = this.getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            MessagePane pane = (MessagePane)children.get(i);
            if (!this.areEqual(category, pane.getCategory())) continue;
            pane.destroy();
        }
    }

    public MessagePane showMessage(String message) {
        return this.showMessage(message, null);
    }

    public MessagePane showMessage(String message, String caption) {
        return this.showMessage(message, caption, null);
    }

    public MessagePane showMessage(String message, String caption, String clazz) {
        return this.showMessage(message, caption, clazz, 8000);
    }

    public MessagePane showMessage(String message, String caption, String clazz, int duration) {
        return this.showMessage(message, caption, clazz, duration, null, null);
    }

    public MessagePane showMessage(String message, String caption, String clazz, Integer duration, String category) {
        return this.showMessage(message, caption, clazz, duration, category, null);
    }

    public MessagePane showMessage(String message, String title, String clazz, int duration, String category, IEventListener actionListener) {
        MessagePane pane = new MessagePane(title, category, duration, actionListener != null);
        pane.addClass(clazz);
        pane.addChild(new Cell(message));
        if (actionListener != null) {
            pane.addEventListener("action", actionListener);
        }
        this.addChild(pane);
        return pane;
    }
}

