/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseUIComponent;
import org.fujion.event.ChangeEvent;
import org.springframework.util.Assert;

@Component(tag="slider", widgetClass="Slider", parentTag={"*"})
public class Slider
extends BaseUIComponent {
    private Orientation orientation = Orientation.HORIZONTAL;
    private int value;
    private int maxValue = 100;
    private int minValue;
    private int step = 1;
    private boolean synced;

    @Component.PropertyGetter(value="value")
    public int getValue() {
        return this.value;
    }

    @Component.PropertySetter(value="value")
    public void setValue(int value) {
        if (value != this.value) {
            this.value = value;
            this.sync("value", this.value);
        }
    }

    @Component.PropertyGetter(value="maxValue")
    public int getMaxValue() {
        return this.maxValue;
    }

    @Component.PropertySetter(value="maxValue")
    public void setMaxValue(int maxValue) {
        if (maxValue != this.maxValue) {
            this.maxValue = maxValue;
            this.sync("maxValue", this.maxValue);
        }
    }

    @Component.PropertyGetter(value="minValue")
    public int getMinValue() {
        return this.minValue;
    }

    @Component.PropertySetter(value="minValue")
    public void setMinValue(int minValue) {
        if (minValue != this.minValue) {
            this.minValue = minValue;
            this.sync("minValue", this.minValue);
        }
    }

    @Component.PropertyGetter(value="orientation")
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Component.PropertySetter(value="orientation")
    public void setOrientation(Orientation orientation) {
        Orientation orientation2 = orientation = orientation == null ? Orientation.HORIZONTAL : orientation;
        if (orientation != this.orientation) {
            this.orientation = orientation;
            this.sync("orientation", (Object)this.orientation);
        }
    }

    @Component.PropertyGetter(value="step")
    public int getStep() {
        return this.step;
    }

    @Component.PropertySetter(value="step")
    public void setStep(int step) {
        Assert.isTrue((step > 0 ? 1 : 0) != 0, (String)"Step value must be greater than zero.");
        if (step != this.step) {
            this.step = step;
            this.sync("step", this.step);
        }
    }

    @Component.PropertyGetter(value="synchronized")
    public boolean getSynchronized() {
        return this.synced;
    }

    @Component.PropertySetter(value="synchronized")
    protected void setSynchronized(boolean synced) {
        if (synced != this.synced) {
            this.synced = synced;
            this.sync("synced", this.synced);
        }
    }

    @EventHandler(value={"change"}, syncToClient=false)
    private void _onChange(ChangeEvent event) {
        this.value = this.defaultify(event.getValue(Integer.class), this.value);
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

