/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.logging;

import java.util.HashMap;
import java.util.Map;

public class LogUtil {
    private static Map<LogLevel, LogTarget> settings = new HashMap<LogLevel, LogTarget>();
    private static String clientSettings;

    public static void initSettings(Map<String, String> settings) {
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            LogUtil.setTarget(LogUtil.toLevel(entry.getKey()), LogUtil.toTarget(entry.getValue()));
        }
    }

    public static LogTarget getTarget(LogLevel level) {
        LogTarget target = settings.get((Object)level);
        return target == null ? LogTarget.NONE : target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogTarget setTarget(LogLevel level, LogTarget target) {
        Map<LogLevel, LogTarget> map = settings;
        synchronized (map) {
            clientSettings = null;
            if (target == null || target == LogTarget.NONE) {
                return settings.remove((Object)level);
            }
            return settings.put(level, target);
        }
    }

    public static String getSettingsForClient() {
        return clientSettings == null ? LogUtil.initSettingsForClient() : clientSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String initSettingsForClient() {
        Map<LogLevel, LogTarget> map = settings;
        synchronized (map) {
            StringBuilder sb = new StringBuilder("{");
            String delim = "";
            for (Map.Entry<LogLevel, LogTarget> entry : settings.entrySet()) {
                if (entry.getValue() == null || entry.getValue() == LogTarget.NONE) continue;
                sb.append(delim).append(entry.getKey().name().toLowerCase()).append(":").append(entry.getValue().ordinal());
                delim = ",";
            }
            clientSettings = sb.append("}").toString();
        }
        return clientSettings;
    }

    public static LogLevel toLevel(String level) {
        try {
            return LogLevel.valueOf(level.toUpperCase());
        }
        catch (Exception e) {
            return LogLevel.UNKNOWN;
        }
    }

    public static LogTarget toTarget(String target) {
        try {
            return LogTarget.valueOf(target.toUpperCase());
        }
        catch (Exception e) {
            return LogTarget.NONE;
        }
    }

    private LogUtil() {
    }

    public static enum LogTarget {
        NONE,
        CLIENT,
        SERVER,
        BOTH;

    }

    public static enum LogLevel {
        UNKNOWN,
        DEBUG,
        ERROR,
        FATAL,
        INFO,
        TRACE,
        WARN;

    }
}

