/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.taglib.TagLibrary;

public class PageElement {
    private final PageElement parent;
    private final ComponentDefinition definition;
    private Map<String, String> attributes;
    private Map<String, TagLibrary> tagLibraries;
    private List<PageElement> children;
    private Map<String, Integer> childCounts;

    PageElement(ComponentDefinition definition, PageElement parent) {
        this.definition = definition;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    private void addChild(PageElement child) {
        if (this.children == null) {
            this.children = new ArrayList<PageElement>();
            this.childCounts = new HashMap<String, Integer>();
        }
        if (this.getDefinition() == null) {
            this.children.add(child);
            return;
        }
        String childTag = child.getDefinition().getTag();
        Integer count = this.childCounts.getOrDefault(childTag, 0);
        this.getDefinition().validateChild(child.getDefinition(), () -> count);
        this.children.add(child);
        this.childCounts.put(childTag, count + 1);
    }

    void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    protected void validate() {
        if (this.children == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        HashMap<String, ComponentDefinition.Cardinality> map = new HashMap<String, ComponentDefinition.Cardinality>(this.getDefinition().getChildTags());
        map.remove("*");
        for (Map.Entry<String, Integer> entry : this.childCounts.entrySet()) {
            int count = entry.getValue();
            String tag = entry.getKey();
            ComponentDefinition.Cardinality cardinality = this.getDefinition().getCardinality(tag);
            map.remove(tag);
            if (cardinality.isValid(count)) continue;
            this.build(sb, "The number of occurrences (%d) for tag '%s' falls outside the range of %d - %d.", count, tag, cardinality.getMinimum(), cardinality.getMaximum());
        }
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (((ComponentDefinition.Cardinality)((Object)entry.getValue())).getMinimum() <= 0) continue;
            this.build(sb, "A required child tag (%s) is missing.", entry.getKey());
        }
        if (sb.length() > 0) {
            throw new RuntimeException(sb.toString());
        }
    }

    private void build(StringBuilder sb, String format, Object ... args) {
        sb.append(sb.length() == 0 ? "" : "\n").append(String.format(format, args));
    }

    public ComponentDefinition getDefinition() {
        return this.definition;
    }

    public PageElement getParent() {
        return this.parent;
    }

    public Iterable<PageElement> getChildren() {
        return this.children;
    }

    public Map<String, String> getAttributes() {
        return this.attributes == null ? null : new HashMap<String, String>(this.attributes);
    }

    public void addTagLibrary(String prefix, TagLibrary tagLibrary) {
        this.tagLibraries = this.tagLibraries == null ? new HashMap() : this.tagLibraries;
        this.tagLibraries.put(prefix, tagLibrary);
    }

    public TagLibrary getTagLibrary(String prefix) {
        TagLibrary lib;
        TagLibrary tagLibrary = lib = this.tagLibraries == null ? null : this.tagLibraries.get(prefix);
        return lib != null ? lib : (this.parent == null ? null : this.parent.getTagLibrary(prefix));
    }
}

