/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.page;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.ComponentRegistry;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.common.MiscUtil;
import org.fujion.common.RegistryMap;
import org.fujion.core.WebUtil;
import org.fujion.page.PIParserAttribute;
import org.fujion.page.PIParserBase;
import org.fujion.page.PIParserTagLibrary;
import org.fujion.page.PageDefinition;
import org.fujion.page.PageElement;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class PageParser {
    private static final PageParser instance = new PageParser();
    private static final String CONTENT_TAG = "#text";
    private final RegistryMap<String, PIParserBase> piParsers = new RegistryMap(RegistryMap.DuplicateAction.ERROR);
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public static PageParser getInstance() {
        return instance;
    }

    private PageParser() {
        this.registerPIParser(new PIParserTagLibrary());
        this.registerPIParser(new PIParserAttribute());
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    public PageDefinition parse(String src) {
        return this.parse(WebUtil.getResource(src));
    }

    public PageDefinition parse(Resource resource) {
        try {
            PageDefinition def = this.parse(resource.getInputStream());
            def.setSource(resource.getFilename());
            return def;
        }
        catch (Exception e) {
            throw new ComponentException((Throwable)e, "Exception parsing resource '" + resource.getFilename() + "'", new Object[0]);
        }
    }

    public PageDefinition parse(InputStream stream) {
        try {
            Document document = this.documentBuilderFactory.newDocumentBuilder().parse(stream);
            PageDefinition pageDefinition = new PageDefinition();
            this.parseNode(document, pageDefinition.getRootElement());
            PageDefinition pageDefinition2 = pageDefinition;
            return pageDefinition2;
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public void registerPIParser(PIParserBase piParser) {
        this.piParsers.put((Object)piParser.getTarget(), (Object)piParser);
    }

    private void parseNode(Node node, PageElement parentElement) {
        ComponentDefinition parentDef = parentElement.getDefinition();
        switch (node.getNodeType()) {
            case 1: {
                Element ele = (Element)node;
                String tag = ele.getTagName();
                ComponentDefinition def = (ComponentDefinition)ComponentRegistry.getInstance().get(tag);
                if (def == null) {
                    throw new RuntimeException("Unrecognized tag: " + tag);
                }
                PageElement childElement = new PageElement(def, parentElement);
                NamedNodeMap attributes = ele.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attr = attributes.item(i);
                    String name = attr.getNodeName();
                    if (name.startsWith("xml")) continue;
                    childElement.setAttribute(name, attr.getNodeValue());
                }
                this.parseChildren(node, childElement);
                childElement.validate();
                break;
            }
            case 3: 
            case 4: {
                Text text = (Text)node;
                String value = text.getWholeText();
                if (value.trim().isEmpty()) break;
                switch (parentDef.contentHandling()) {
                    case ERROR: {
                        throw new RuntimeException("Text content is not allowed for tag " + parentDef.getTag());
                    }
                    case IGNORE: {
                        break;
                    }
                    case AS_ATTRIBUTE: {
                        parentElement.setAttribute(CONTENT_TAG, this.normalizeText(value));
                        break;
                    }
                    case AS_CHILD: {
                        ComponentDefinition def = (ComponentDefinition)ComponentRegistry.getInstance().get(CONTENT_TAG);
                        PageElement childElement = new PageElement(def, parentElement);
                        childElement.setAttribute(CONTENT_TAG, this.normalizeText(value));
                    }
                }
                break;
            }
            case 9: {
                this.parseChildren(node, parentElement);
                break;
            }
            case 8: {
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                PIParserBase piParser = (PIParserBase)this.piParsers.get((Object)pi.getTarget());
                if (piParser != null) {
                    piParser.parse(pi, parentElement);
                    break;
                }
                throw new RuntimeException("Unrecognized prosessing instruction: " + pi.getTarget());
            }
            default: {
                throw new RuntimeException("Unrecognized document content: " + node.getNodeName());
            }
        }
    }

    private void parseChildren(Node node, PageElement parentElement) {
        NodeList children = node.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node childNode = children.item(i);
            this.parseNode(childNode, parentElement);
        }
    }

    private String normalizeText(String text) {
        int i = text.indexOf(10);
        if (i == -1) {
            return text;
        }
        if (text.substring(0, i).trim().isEmpty()) {
            text = text.substring(i + 1);
        }
        if ((i = text.lastIndexOf(10)) >= 0 && text.substring(i).trim().isEmpty()) {
            text = text.substring(0, i);
        }
        return text;
    }
}

