/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.servlet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.annotation.ComponentScanner;
import org.fujion.annotation.EventTypeScanner;
import org.fujion.component.BaseComponent;
import org.fujion.event.Event;
import org.fujion.servlet.FujionResourceTransformer;
import org.fujion.servlet.MinifiedResourceResolver;
import org.fujion.servlet.WebJarResourceResolver;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceChainRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.resource.AppCacheManifestTransformer;
import org.springframework.web.servlet.resource.GzipResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.VersionResourceResolver;

@EnableWebMvc
@Configuration
public class ServletConfiguration
extends WebMvcConfigurerAdapter
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(ServletConfiguration.class);
    private final GzipResourceResolver gzipResourceResolver = new GzipResourceResolver();
    private final ResourceResolver contentVersionResolver = new VersionResourceResolver().addContentVersionStrategy(new String[]{"/**"});
    private final ResourceResolver webjarResourceResolver = new WebJarResourceResolver();
    private final FujionResourceTransformer fujionResourceTransformer = new FujionResourceTransformer();
    private final AppCacheManifestTransformer appCacheManifestTransformer = new AppCacheManifestTransformer();
    private final MinifiedResourceResolver minifiedResourceResolver = new MinifiedResourceResolver("js", "css");
    private ApplicationContext applicationContext;

    public ServletConfiguration() {
        ComponentScanner.getInstance().scanPackage(BaseComponent.class.getPackage());
        EventTypeScanner.getInstance().scanPackage(Event.class.getPackage());
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.mediaType("fsp", MediaType.TEXT_HTML);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        this.addResourceHandlers(registry, "/webjars/**", "classpath:/META-INF/resources/webjars/", this.webjarResourceResolver);
        this.addResourceHandlers(registry, "/web/**", "classpath:/web/", null);
        this.addResourceHandlers(registry, "/**", "/", this.contentVersionResolver);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        try {
            Resource[] resources = this.applicationContext.getResources("/index.*");
            if (resources.length > 0) {
                if (resources.length > 1) {
                    log.warn((Object)"Multiple home page candidates detected - only one will be selected.");
                }
                String file = "/" + resources[0].getFilename();
                registry.addRedirectViewController("/", file);
                log.info((Object)("Default home page set to: " + file));
            } else {
                log.info((Object)"No default home page detected.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while attempting to detect default home page.", (Throwable)e);
        }
    }

    private void addResourceHandlers(ResourceHandlerRegistry registry, String pattern, String locations, ResourceResolver customResourceResolver) {
        ResourceChainRegistration chain = registry.addResourceHandler(new String[]{pattern}).addResourceLocations(new String[]{locations}).resourceChain(false);
        if (customResourceResolver != null) {
            chain.addResolver(customResourceResolver);
        }
        chain.addResolver((ResourceResolver)this.minifiedResourceResolver).addResolver((ResourceResolver)this.gzipResourceResolver).addTransformer((ResourceTransformer)this.fujionResourceTransformer).addTransformer((ResourceTransformer)this.appCacheManifestTransformer);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

