/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.OptionMap;
import org.fujion.annotation.JavaScript;

public abstract class Options
implements OptionMap.IOptionMapConverter {
    @Override
    public OptionMap toMap() {
        OptionMap map = new OptionMap();
        this.toMap(this.getClass(), map);
        return map;
    }

    private void toMap(Class<?> clazz, OptionMap map) {
        if (clazz == Options.class) {
            return;
        }
        this.toMap(clazz.getSuperclass(), map);
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isPrivate(modifiers)) continue;
            try {
                String name = field.getName();
                Object value = field.get(this);
                if (value != null && field.isAnnotationPresent(JavaScript.class)) {
                    value = ConvertUtil.convertToJS(value.toString());
                }
                if (value == null) continue;
                this.setValue(name, value, map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setValue(String name, Object value, OptionMap map) {
        if (name.contains("_")) {
            String[] pcs = name.split("\\_", 2);
            OptionMap submap = (OptionMap)map.get(name = pcs[0]);
            if (submap == null) {
                submap = new OptionMap();
            }
            this.setValue(pcs[1], value, submap);
            map.put(name, (Object)submap);
        } else {
            map.put(name, value);
        }
    }

    public void copyTo(Options target) {
        if (target.getClass() != this.getClass()) {
            throw new IllegalArgumentException();
        }
        for (Field field : this.getClass().getFields()) {
            if (!field.isAccessible() || Modifier.isTransient(field.getModifiers())) continue;
            try {
                field.set(target, field.get(this));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

