/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import org.apache.commons.beanutils.ConstructorUtils;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.ComponentFactory;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.annotation.Component;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;

public class ComponentDefinition {
    private final Component.ContentHandling contentHandling;
    private final String tag;
    private final Class<? extends BaseComponent> componentClass;
    private final Class<? extends ComponentFactory> factoryClass;
    private final String widgetModule;
    private final String widgetClass;
    private final Set<String> parentTags = new HashSet<String>();
    private final Map<String, Cardinality> childTags = new HashMap<String, Cardinality>();
    private final Map<String, Method> getters = new HashMap<String, Method>();
    private final Map<String, Method> setters = new HashMap<String, Method>();
    private final Map<String, Method> parameters = new HashMap<String, Method>();
    private final Set<String> deferred = new HashSet<String>();

    public ComponentDefinition(Class<? extends BaseComponent> componentClass) {
        Component annot = componentClass.getAnnotation(Component.class);
        this.componentClass = componentClass;
        this.factoryClass = annot.factoryClass();
        this.widgetModule = annot.widgetModule();
        this.widgetClass = annot.widgetClass();
        this.tag = annot.tag();
        this.contentHandling = annot.content();
        for (String string : annot.parentTag()) {
            this.addParentTag(string);
        }
        for (Component.ChildTag childTag : annot.childTag()) {
            this.addChildTag(childTag);
        }
    }

    public Object getProperty(BaseComponent instance, String name) throws Exception {
        Method method = this.getters.get(name);
        if (method == null) {
            throw new RuntimeException("Property cannot be read: " + name);
        }
        return method.invoke((Object)instance, new Object[0]);
    }

    public DeferredSetter setProperty(BaseComponent instance, String name, Object value) {
        if (name.startsWith("@")) {
            instance.setAttribute(name.substring(1), value);
            return null;
        }
        Method method = this.setters.get(name);
        if (method == null) {
            if (this.parameters.containsKey(name)) {
                return null;
            }
            String message = this.getters.containsKey(name) ? "Property is read-only" : "Property is not recognized";
            throw new ComponentException(message + ": " + name, new Object[0]);
        }
        if (this.deferred.contains(name)) {
            return new DeferredSetter(instance, method, value);
        }
        ConvertUtil.invokeSetter(instance, method, value);
        return null;
    }

    public String getTag() {
        return this.tag;
    }

    public Class<? extends BaseComponent> getComponentClass() {
        return this.componentClass;
    }

    public Class<? extends ComponentFactory> getFactoryClass() {
        return this.factoryClass;
    }

    public ComponentFactory getFactory() {
        try {
            return (ComponentFactory)ConstructorUtils.invokeConstructor(this.factoryClass, (Object)this);
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public String getWidgetModule() {
        return this.widgetModule;
    }

    public String getWidgetClass() {
        return this.widgetClass;
    }

    public Cardinality getCardinality(String childTag) {
        Cardinality cardinality = this.childTags.get(childTag);
        return cardinality == null ? this.childTags.get("*") : cardinality;
    }

    public Map<String, Cardinality> getChildTags() {
        return Collections.unmodifiableMap(this.childTags);
    }

    public boolean childrenAllowed() {
        return this.childTags.size() > 0;
    }

    public void validateChild(ComponentDefinition childDefinition, IntSupplier childCount) {
        if (!this.childrenAllowed()) {
            throw new ComponentException(this.componentClass, "Children are not allowed", new Object[0]);
        }
        childDefinition.validateParent(this);
        Cardinality cardinality = this.getCardinality(childDefinition.tag);
        if (cardinality == null) {
            throw new ComponentException(this.componentClass, "%s is not a valid child", childDefinition.componentClass);
        }
        if (cardinality.hasMaximum() && childCount.getAsInt() >= cardinality.getMaximum()) {
            throw new ComponentException(this.componentClass, "A maximum of %d children of type %s are allowed", cardinality.getMaximum(), childDefinition.componentClass);
        }
    }

    public void validateParent(ComponentDefinition parentDefinition) {
        if (!this.isParentTag(parentDefinition.tag)) {
            throw new ComponentException(this.componentClass, "%s is not a valid parent", parentDefinition.componentClass);
        }
    }

    public boolean isParentTag(String tag) {
        return this.parentTags.contains(tag) || this.parentTags.contains("*");
    }

    public Set<String> getParentTags() {
        return Collections.unmodifiableSet(this.parentTags);
    }

    public Component.ContentHandling contentHandling() {
        return this.contentHandling;
    }

    private void addParentTag(String tag) {
        this.parentTags.add(tag);
    }

    private void addChildTag(Component.ChildTag tag) {
        this.childTags.put(tag.value(), new Cardinality(tag.minimum(), tag.maximum()));
    }

    private boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    void _addGetter(Component.PropertyGetter getter, Method method) {
        String name = getter.value();
        if (!this.getters.containsKey(name)) {
            if (this.isStatic(method) || method.getReturnType() == Void.TYPE || method.getParameterTypes().length > 0) {
                throw new IllegalArgumentException("Bad signature for getter method: " + method.getName());
            }
            this.getters.put(name, getter.hide() ? null : method);
        }
    }

    public Map<String, Method> getGetters() {
        return Collections.unmodifiableMap(this.getters);
    }

    void _addSetter(Component.PropertySetter setter, Method method) {
        String name = setter.value();
        if (!this.setters.containsKey(name)) {
            if (this.isStatic(method) || method.getParameterTypes().length != 1) {
                throw new IllegalArgumentException("Bad signature for setter method: " + method.getName());
            }
            this.setters.put(name, setter.hide() ? null : method);
            if (setter.defer()) {
                this.deferred.add(name);
            }
        }
    }

    public Map<String, Method> getSetters() {
        return Collections.unmodifiableMap(this.setters);
    }

    void _addFactoryParameter(Component.FactoryParameter parameter, Method method) {
        String name = parameter.value();
        if (!this.parameters.containsKey(name)) {
            if (this.isStatic(method) || method.getParameterTypes().length != 1) {
                throw new IllegalArgumentException("Bad signature for factory parameter method: " + method.getName());
            }
            this.parameters.put(name, method);
        }
    }

    public Map<String, Method> getFactoryParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean equals(Object object) {
        return object instanceof ComponentDefinition && ((ComponentDefinition)object).componentClass == this.componentClass;
    }

    public static class DeferredSetter {
        private final Object instance;
        private final Method method;
        private final Object value;

        DeferredSetter(Object instance, Method method, Object value) {
            this.instance = instance;
            this.method = method;
            this.value = value;
        }

        public void execute() {
            ConvertUtil.invokeSetter(this.instance, this.method, this.value);
        }
    }

    public static class Cardinality {
        private final int minimum;
        private final int maximum;

        Cardinality(int minimum, int maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public int getMinimum() {
            return this.minimum;
        }

        public int getMaximum() {
            return this.maximum;
        }

        public boolean hasMinimum() {
            return this.minimum > 0;
        }

        public boolean hasMaximum() {
            return this.maximum != Integer.MAX_VALUE;
        }

        public boolean isValid(int count) {
            return count >= this.minimum && count <= this.maximum;
        }
    }
}

