/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.core.test;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.CssClasses;
import org.fujion.ancillary.CssStyles;
import org.fujion.ancillary.DeferredInvocation;
import org.fujion.ancillary.MimeContent;
import org.fujion.component.Div;
import org.fujion.event.KeyCode;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.util.Base64Utils;

public class Tests {
    private static final String ATTR_TEST = "ATTR_TEST";
    private static final String ATTR_OBJECT = "ATTR_OBJECT";
    private static final String ATTR_NULL = "ATTR_NULL";
    private static final byte[] TEST_CONTENT = new byte[]{97, 101, 105, 111, 117};

    @Test
    public void attributeTests() {
        Div cmpt = new Div();
        cmpt.setAttribute(ATTR_OBJECT, new Object());
        cmpt.setAttribute(ATTR_TEST, (Object)1234);
        Assert.assertTrue((1234 == (Integer)cmpt.getAttribute(ATTR_TEST, (Object)0) ? 1 : 0) != 0);
        Assert.assertTrue((4321 == (Integer)cmpt.getAttribute(ATTR_OBJECT, (Object)4321) ? 1 : 0) != 0);
        Assert.assertTrue((5678 == (Integer)cmpt.getAttribute(ATTR_NULL, (Object)5678) ? 1 : 0) != 0);
        cmpt.setAttribute(ATTR_TEST, (Object)true);
        Assert.assertTrue((boolean)((Boolean)cmpt.getAttribute(ATTR_TEST, Boolean.class)));
        cmpt.setAttribute(ATTR_TEST, (Object)"TRUE");
        Assert.assertTrue((boolean)((Boolean)cmpt.getAttribute(ATTR_TEST, Boolean.class)));
        cmpt.setAttribute(ATTR_TEST, (Object)"ANYTHING BUT TRUE");
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_TEST, Boolean.class));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_OBJECT, Boolean.class));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_NULL, Boolean.class));
        cmpt.setAttribute(ATTR_TEST, (Object)ATTR_TEST);
        Assert.assertEquals((Object)ATTR_TEST, (Object)cmpt.getAttribute(ATTR_TEST, String.class));
        Assert.assertTrue((boolean)((String)cmpt.getAttribute(ATTR_OBJECT, String.class)).contains("Object"));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_NULL, String.class));
        ArrayList list = new ArrayList();
        cmpt.setAttribute(ATTR_TEST, list);
        Assert.assertSame(list, (Object)cmpt.getAttribute(ATTR_TEST, List.class));
        Assert.assertNotNull((Object)cmpt.getAttribute(ATTR_OBJECT));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_NULL));
        cmpt.setAttribute(ATTR_TEST, (Object)cmpt);
        Assert.assertSame((Object)cmpt, (Object)cmpt.getAttribute(ATTR_TEST, Div.class));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_OBJECT, Div.class));
    }

    @Test
    public void conversionTests() {
        Assert.assertEquals((Object)"true", (Object)ConvertUtil.convert((Object)true, String.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ConvertUtil.convert((Object)"true", Boolean.class));
        Assert.assertEquals((Object)((Object)TestEnum.TEST1), (Object)ConvertUtil.convert((Object)"test1", TestEnum.class));
        Assert.assertEquals((Object)"TEST2", (Object)ConvertUtil.convert((Object)((Object)TestEnum.TEST2), String.class));
        Assert.assertEquals((Object)"function() {var x=1}", (Object)ConvertUtil.convertToJS((String)"var x=1"));
        Assert.assertEquals((Object)"function() {var x=1}", (Object)ConvertUtil.convertToJS((String)"function() {var x=1}"));
    }

    @Test
    public void cssClassesTests() {
        CssClasses classes = new CssClasses();
        Assert.assertTrue((!classes.hasChanged() ? 1 : 0) != 0);
        classes.parse("flavor:red size:big test");
        Assert.assertTrue((boolean)classes.hasChanged());
        Assert.assertEquals((Object)"big red test", (Object)classes.toString());
        classes.add(new String[]{"flavor:blue size:small -test"});
        Assert.assertEquals((Object)"blue small", (Object)classes.toString());
        classes.remove(new String[]{"flavor:"});
        Assert.assertEquals((Object)"small", (Object)classes.toString());
        classes.add(new String[]{"-size:"});
        Assert.assertTrue((boolean)classes.hasChanged());
        Assert.assertEquals((Object)"", (Object)classes.toString(true));
        Assert.assertTrue((!classes.hasChanged() ? 1 : 0) != 0);
    }

    @Test
    public void cssStylesTests() {
        CssStyles styles = new CssStyles();
        Assert.assertTrue((boolean)styles.isEmpty());
        styles.put("style1", "value1");
        Assert.assertTrue((!styles.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"style1:value1", (Object)styles.toString());
        Assert.assertEquals((Object)"value1", (Object)styles.get("style1"));
        styles.parse("style2 : value2", false);
        Assert.assertEquals((Object)"style1:value1;style2:value2", (Object)styles.toString());
        Assert.assertEquals((Object)"value1", (Object)styles.get("style1"));
        Assert.assertEquals((Object)"value2", (Object)styles.get("style2"));
        styles.remove("style1");
        Assert.assertEquals((Object)"style2:value2", (Object)styles.toString());
        Assert.assertNull((Object)styles.get("style1"));
        styles.parse("style1:value1", true);
        Assert.assertEquals((Object)"style1:value1", (Object)styles.toString());
        styles.put("style1", null);
        Assert.assertTrue((boolean)styles.isEmpty());
    }

    @Test
    public void deferredInvocationTests() throws Exception {
        Method method = Tests.class.getDeclaredMethod("_testMethod", String.class, String.class);
        DeferredInvocation inv1 = new DeferredInvocation((Object)this, method, new Object[0]);
        Assert.assertEquals((Object)"test1;test2", (Object)inv1.invoke(new Object[]{"test1", "test2"}));
        DeferredInvocation inv2 = new DeferredInvocation((Object)this, method, new Object[]{"test3"});
        Assert.assertEquals((Object)"test3;test4", (Object)inv2.invoke(new Object[]{"test4"}));
        DeferredInvocation inv3 = new DeferredInvocation((Object)this, method, new Object[]{"test5", "test6"});
        Assert.assertEquals((Object)"test5;test6", (Object)inv3.invoke(new Object[0]));
        DeferredInvocation inv4 = new DeferredInvocation((Object)this, method, new Object[]{TestEnum.TEST1, TestEnum.TEST2});
        Assert.assertEquals((Object)"TEST1;TEST2", (Object)inv4.invoke(new Object[0]));
        try {
            inv4.addArgs(new Object[]{new Object()});
            Assert.fail((String)"Expected illegal argument exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected String _testMethod(String arg1, String arg2) {
        return arg1 + ";" + arg2;
    }

    @Test
    public void keyCodeTests() {
        Assert.assertEquals((Object)KeyCode.VK_BACK_SPACE, (Object)KeyCode.fromCode((int)8));
        Assert.assertEquals((Object)KeyCode.VK_ASTERISK, (Object)KeyCode.fromString((String)"ASTERISK"));
        Assert.assertEquals((Object)KeyCode.normalizeKeyCapture((String)"^A ~F1 ^@~@^$1"), (Object)"^#65 ~#112 ^@~$#49");
    }

    @Test
    public void mimeContentTests() {
        MimeContent content = new MimeContent("image/png", TEST_CONTENT);
        String src = content.getSrc();
        Assert.assertEquals((Object)"data:image/png;base64,YWVpb3U=", (Object)src);
        Assert.assertEquals((Object)"aeiou", (Object)new String(Base64Utils.decodeFromString((String)src.split("\\,", 2)[1])));
    }

    private static enum TestEnum {
        TEST1,
        TEST2,
        TEST3;

    }
}

