/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import org.fujion.component.BaseComponent;
import org.fujion.event.Event;

public class Badge {
    private final BaseComponent owner;
    private int count;

    public Badge(BaseComponent owner) {
        this(owner, 0);
    }

    public Badge(BaseComponent owner, int count) {
        this.owner = owner;
        this.updateCount(count);
    }

    public BaseComponent getOwner() {
        return this.owner;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.updateCount(count);
    }

    public void incCount(int increment) {
        this.updateCount(this.count + increment);
    }

    private void updateCount(int newCount) {
        if (newCount != this.count) {
            int delta = newCount - this.count;
            this.count = newCount;
            Event event = new Event("badge", this.owner, delta);
            this.owner.notifyAncestors(event, true);
        }
    }
}

