/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import java.lang.reflect.InvocationTargetException;
import org.fujion.component.BaseComponent;
import org.springframework.core.NestedRuntimeException;

public class ComponentException
extends NestedRuntimeException {
    private static final long serialVersionUID = 1L;
    private final BaseComponent component;
    private final Class<? extends BaseComponent> componentClass;

    private static String formatMessage(Class<?> componentClass, BaseComponent component, String message, Object ... args) {
        Object object = component != null ? component : componentClass;
        return (object == null ? "" : object + ": ") + String.format(message, args);
    }

    private static Throwable getCause(Throwable cause) {
        return cause instanceof InvocationTargetException ? cause.getCause() : cause;
    }

    private ComponentException(Throwable cause, Class<? extends BaseComponent> componentClass, BaseComponent component, String message, Object ... args) {
        super(ComponentException.formatMessage(componentClass, component, message, args), ComponentException.getCause(cause));
        this.component = component;
        this.componentClass = component != null ? component.getClass() : componentClass;
    }

    public ComponentException(Throwable cause, String message, Object ... args) {
        this(cause, null, null, message, args);
    }

    public ComponentException(Throwable cause, Class<? extends BaseComponent> componentClass, String message, Object ... args) {
        this(cause, componentClass, null, message, args);
    }

    public ComponentException(Throwable cause, BaseComponent component, String message, Object ... args) {
        this(cause, null, component, message, args);
    }

    public ComponentException(String message, Object ... args) {
        this(null, null, null, message, args);
    }

    public ComponentException(Class<? extends BaseComponent> componentClass, String message, Object ... args) {
        this(null, componentClass, null, message, args);
    }

    public ComponentException(BaseComponent component, String message, Object ... args) {
        this(null, null, component, message, args);
    }

    public BaseComponent getComponent() {
        return this.component;
    }

    public Class<? extends BaseComponent> getComponentClass() {
        return this.componentClass;
    }
}

