/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.common.MiscUtil;
import org.fujion.common.StrUtil;

public enum OnFailure {
    IGNORE,
    EXCEPTION,
    LOG;

    private final Log log = LogFactory.getLog(OnFailure.class);

    void doAction(String message, Object ... args) {
        switch (this) {
            case IGNORE: {
                return;
            }
            case EXCEPTION: {
                message = StrUtil.formatMessage((String)message, (Object[])args);
                throw new RuntimeException(message);
            }
            case LOG: {
                message = StrUtil.formatMessage((String)message, (Object[])args);
                this.log.warn((Object)message);
                return;
            }
        }
    }

    void doAction(Exception e) {
        switch (this) {
            case IGNORE: {
                return;
            }
            case EXCEPTION: {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
            case LOG: {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
    }
}

