/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.lang.reflect.Field;
import org.fujion.annotation.OnFailure;
import org.fujion.annotation.WiredComponent;
import org.fujion.component.BaseComponent;

public class WiredComponentScanner {
    private WiredComponentScanner() {
    }

    public static void wire(Object instance, BaseComponent root) {
        for (Class<?> clazz = instance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            WiredComponentScanner.wire(instance, root, clazz);
        }
    }

    private static void wire(Object instance, BaseComponent root, Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            WiredComponent annot = field.getAnnotation(WiredComponent.class);
            if (annot == null) continue;
            OnFailure onFailure = annot.onFailure();
            if (!BaseComponent.class.isAssignableFrom(field.getType())) {
                onFailure.doAction("Field \"%s\" is not a component type", field.getName());
                return;
            }
            try {
                if (!annot.overwrite() && field.get(instance) != null) {
                    onFailure.doAction("Field \"%s\" is already assigned a value", field.getName());
                    continue;
                }
                String name = annot.value();
                name = name.isEmpty() ? field.getName() : name;
                BaseComponent component = root.findByName(name);
                if (component == null) {
                    onFailure.doAction("No component matching name \"%s\"", name);
                    continue;
                }
                field.set(instance, component);
            }
            catch (Exception e) {
                onFailure.doAction(e);
            }
        }
    }
}

