/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.client;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.ancillary.IElementIdentifier;

public class ClientInvocation {
    private static final Log log = LogFactory.getLog(ClientInvocation.class);
    private final String function;
    private final IElementIdentifier target;
    private final Object[] arguments;
    private final String key;

    public ClientInvocation(IElementIdentifier target, String function, Object ... arguments) {
        this.target = target;
        this.arguments = arguments;
        String[] pcs = function.split("\\^", 2);
        String string = this.function = pcs.length == 1 ? pcs[0] : pcs[1];
        this.key = pcs.length == 1 ? null : (pcs[0].isEmpty() ? pcs[1] : pcs[0]);
    }

    public ClientInvocation(String moduleName, String function, Object ... arguments) {
        this(moduleName == null ? null : () -> "@" + moduleName, function, arguments);
    }

    public String getKey() {
        return this.key == null ? "" + this.hashCode() : (this.target == null ? this.key : this.key + "^" + this.target.hashCode());
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("fcn", this.function);
        data.put("tgt", this.target == null ? null : this.target.getId());
        data.put("arg", this.transform(this.arguments));
        return data;
    }

    private Object[] transform(Object[] source) {
        for (int i = 0; i < source.length; ++i) {
            source[i] = this.transform(source[i]);
        }
        return source;
    }

    private Object transform(Object source) {
        if (source instanceof IElementIdentifier) {
            String id = ((IElementIdentifier)source).getId();
            if (id == null) {
                log.error((Object)("Component is not attached to a page: " + source));
            }
            return id == null ? null : Collections.singletonMap("__fujion__", id);
        }
        if (source instanceof Map) {
            return this.transformMap((Map)source);
        }
        if (source instanceof Collection) {
            Collection col = (Collection)source;
            Object[] ary = new Object[col.size()];
            return this.transform(col.toArray(ary));
        }
        if (source instanceof Date) {
            return ((Date)source).getTime();
        }
        return source;
    }

    private Object transformMap(Map<Object, Object> source) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object key : source.keySet()) {
            map.put(key, this.transform(source.get(key)));
        }
        return map;
    }
}

