/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.fujion.client.ClientRequest;
import org.fujion.component.Page;
import org.fujion.page.PageRegistry;
import org.fujion.websocket.Session;
import org.springframework.util.Assert;

public class ExecutionContext {
    public static final String ATTR_REQUEST = "fujion_request";
    private static final ThreadLocal<Map<String, Object>> context = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    public static Object put(String key, Object value) {
        return context.get().put(key, value);
    }

    public static Object get(String key) {
        return context.get().get(key);
    }

    public static Object remove(String key) {
        return context.get().remove(key);
    }

    public static void clear() {
        context.get().clear();
    }

    public static void destroy() {
        context.remove();
    }

    public static boolean isEmpty() {
        return context.get().isEmpty();
    }

    public static ClientRequest getRequest() {
        return (ClientRequest)context.get().get(ATTR_REQUEST);
    }

    public static Session getSession() {
        ClientRequest request = ExecutionContext.getRequest();
        return request == null ? null : request.getSession();
    }

    public static Page getPage() {
        ClientRequest request = ExecutionContext.getRequest();
        return request == null ? null : request.getPage();
    }

    public static ServletContext getServletContext() {
        Session session = ExecutionContext.getSession();
        return session == null ? null : session.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invoke(String pid, Runnable callback) {
        Page page = PageRegistry.getPage(pid);
        Page current = ExecutionContext.getPage();
        Assert.isTrue((current == null || current == page ? 1 : 0) != 0, (String)"Cannot switch current page execution context");
        try {
            if (current == null) {
                ExecutionContext.clear();
                ExecutionContext.put(ATTR_REQUEST, new ClientRequest(page.getSession(), Collections.emptyMap()));
            }
            callback.run();
        }
        finally {
            if (current == null) {
                ExecutionContext.destroy();
            }
        }
    }

    private ExecutionContext() {
    }
}

