/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.client;

import java.util.Collection;
import java.util.Map;
import org.fujion.ancillary.IElementIdentifier;
import org.fujion.client.ClientInvocation;
import org.fujion.client.ClientInvocationQueue;
import org.fujion.component.BaseComponent;
import org.fujion.websocket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;

public class Synchronizer {
    private final ClientInvocationQueue queue;
    private final WebSocketSession session;
    private boolean queueing;

    public Synchronizer(WebSocketSession session) {
        this.session = session;
        this.queue = new ClientInvocationQueue();
    }

    public void startQueueing() {
        this.queueing = true;
    }

    public void stopQueueing() {
        this.queueing = false;
        this.sendToClient(this.queue.flush());
    }

    public void clear() {
        this.queue.clear();
    }

    public Synchronizer createWidget(BaseComponent parent, Map<String, Object> props, Map<String, Object> state) {
        return this.sendToClient(new ClientInvocation((String)null, "fujion.widget.create", parent, props, state));
    }

    public Synchronizer processQueue(ClientInvocationQueue queue) {
        return this.sendToClient(queue.flush());
    }

    public Synchronizer invokeClient(IElementIdentifier component, String function, Object ... args) {
        ClientInvocation invocation = new ClientInvocation(component, function, args);
        return this.sendToClient(invocation);
    }

    public Synchronizer sendToClient(ClientInvocation invocation) {
        if (this.queueing) {
            this.queue.queue(invocation);
        } else {
            WebSocketHandler.send(this.session, invocation);
        }
        return this;
    }

    public Synchronizer sendToClient(Collection<ClientInvocation> invocations) {
        if (this.queueing) {
            this.queue.queue(invocations);
        } else {
            WebSocketHandler.send(this.session, invocations);
        }
        return this;
    }
}

