/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.ComponentRegistry;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.IAutoWired;
import org.fujion.ancillary.IElementIdentifier;
import org.fujion.ancillary.ILabeled;
import org.fujion.ancillary.INamespace;
import org.fujion.annotation.Component;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.annotation.EventHandler;
import org.fujion.annotation.EventHandlerScanner;
import org.fujion.annotation.WiredComponentScanner;
import org.fujion.client.ClientInvocation;
import org.fujion.client.ClientInvocationQueue;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseScriptComponent;
import org.fujion.component.Page;
import org.fujion.component.ServerScript;
import org.fujion.event.Event;
import org.fujion.event.EventListeners;
import org.fujion.event.EventUtil;
import org.fujion.event.ForwardListener;
import org.fujion.event.IEventListener;
import org.fujion.event.PropertychangeEvent;
import org.fujion.event.StatechangeEvent;
import org.springframework.util.Assert;

public abstract class BaseComponent
implements IElementIdentifier {
    private static final String ATTR_CONTROLLER = "controller";
    private static final Pattern nameValidator = Pattern.compile("^[a-zA-Z$][a-zA-Z_$0-9]*$");
    private String name;
    private String id;
    private boolean dead;
    private Page page;
    private BaseComponent parent;
    private Object data;
    private String content;
    private boolean contentSynced = true;
    private Map<String, Object> inits;
    private ClientInvocationQueue invocationQueue;
    private boolean namespace;
    private List<Object> controllers;
    private final List<BaseComponent> children = new LinkedList<BaseComponent>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final EventListeners eventListeners = new EventListeners();
    private final ComponentDefinition componentDefinition;
    private final NameIndex nameIndex = new NameIndex();

    protected static void validate(BaseComponent comp) {
        if (comp != null && comp.isDead()) {
            throw new ComponentException("Component no longer exists: %s", comp.getId());
        }
    }

    protected BaseComponent() {
        this.componentDefinition = ComponentRegistry.getInstance().get(this.getClass());
        this.namespace = this instanceof INamespace;
        EventHandlerScanner.wire(this, this);
    }

    public ComponentDefinition getDefinition() {
        return this.componentDefinition;
    }

    @Component.PropertyGetter(value="name", description="The name associated with this component instance (must be unique within the enclosing namespace).")
    public String getName() {
        return this.name;
    }

    @Component.PropertySetter(value="name", description="The name associated with this component instance (must be unique within the enclosing namespace).")
    public void setName(String name) {
        if (!this.areEqual(name = this.nullify(name), this.name)) {
            this.validateName(name);
            this.nameIndex.remove(this);
            this.name = name;
            this.propertyChange("name", this.name, this.name, true);
            this.nameIndex.add(this);
        }
    }

    private void validateName(String name) {
        if (name != null) {
            if (!nameValidator.matcher(name).matches()) {
                throw new ComponentException(this, "Component name is not valid: " + name, new Object[0]);
            }
            this.nameIndex.validate(name);
        }
    }

    @Override
    @Component.PropertyGetter(value="id", description="The unique id of the client widget corresponding to this component.")
    public String getId() {
        return this.id;
    }

    void _setId(String id) {
        Assert.isNull((Object)this.id, (String)"Unique id cannot be modified.");
        this.id = id;
    }

    public void detach() {
        this.setParent(null);
    }

    public void destroy() {
        if (this.dead) {
            return;
        }
        this.onDestroy();
        if (this.page != null) {
            this.page.registerComponent(this, false);
        }
        this.destroyChildren();
        if (this.parent != null) {
            this.parent._removeChild(this, false, true);
        } else {
            this.invokeIfAttached("destroy", new Object[0]);
        }
        this.dead = true;
        this.fireEvent("destroy");
        this.eventListeners.removeAll();
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.id != null) {
            this.destroy();
        }
    }

    public void destroyChildren() {
        while (!this.children.isEmpty()) {
            this.children.get(0).destroy();
        }
    }

    protected void onDestroy() {
    }

    public boolean isDead() {
        return this.dead;
    }

    protected void validate() {
        BaseComponent.validate(this);
    }

    public BaseComponent getParent() {
        return this.parent;
    }

    protected boolean validateParent(BaseComponent parent) {
        return parent == null || this.componentDefinition.isParentTag(parent.componentDefinition.getTag());
    }

    public void setParent(BaseComponent parent) {
        if (parent != this.parent) {
            if (parent == null) {
                this.parent.removeChild(this);
            } else if (this.validateParent(parent)) {
                parent.addChild(this);
            } else {
                throw new ComponentException(this, "Not a valid parent: " + parent.getClass().getName(), new Object[0]);
            }
        }
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public <T> T getAttribute(String name, T dflt) {
        try {
            Object value = this.attributes.get(name);
            return (T)(value == null ? dflt : (dflt == null ? value : dflt.getClass().cast(value)));
        }
        catch (Exception e) {
            return dflt;
        }
    }

    public <T> T getAttribute(String name, Class<T> type) {
        try {
            return ConvertUtil.convert(this.attributes.get(name), type, this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object findAttribute(String name) {
        Object value = null;
        for (BaseComponent cmp = this; cmp != null && (value = cmp.attributes.get(name)) == null; cmp = cmp.getParent()) {
        }
        return value;
    }

    @Component.PropertySetter(value="attr:")
    public Object setAttribute(String name, Object value) {
        return this.attributes.put(name, value);
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    protected void validateIsChild(BaseComponent child) {
        if (child != null && child.getParent() != this) {
            throw new ComponentException("Child does not belong to this parent.", new Object[0]);
        }
    }

    protected void validateChild(BaseComponent child) {
        this.componentDefinition.validateChild(child.componentDefinition, () -> this.getChildCount(child.getClass()));
    }

    public void addChild(BaseComponent child) {
        this.addChild(child, -1);
    }

    public void addChild(BaseComponent child, int index) {
        boolean noSync = child.getPage() == null && index < 0;
        child.validate();
        BaseComponent oldParent = child.getParent();
        if (oldParent != this) {
            this.validateChild(child);
            this.nameIndex.validate(child);
        }
        child.validatePage(this.page);
        if (oldParent == this) {
            int i = child.getIndex();
            if (i == index) {
                return;
            }
            if (index > i) {
                --index;
            }
        } else {
            child.beforeSetParent(this);
            this.beforeAddChild(child);
        }
        if (oldParent != null) {
            oldParent._removeChild(child, true, false);
        }
        if (index < 0) {
            this.children.add(child);
        } else {
            this.children.add(index, child);
        }
        child.parent = this;
        if (this.page != null) {
            child._attach(this.page);
        }
        this.nameIndex.add(child);
        if (!noSync) {
            this.invokeIfAttached("addChild", child, index);
        }
        if (oldParent != this) {
            this.afterAddChild(child);
            child.afterSetParent(this);
        }
    }

    public void addChild(BaseComponent child, BaseComponent before) {
        if (before == null) {
            this.addChild(child);
            return;
        }
        if (before.getParent() != this) {
            throw new ComponentException(this, "Before component does not belong to this parent.", new Object[0]);
        }
        int i = this.children.indexOf(before);
        this.addChild(child, i);
    }

    public void addChildren(Collection<? extends BaseComponent> children) {
        for (BaseComponent baseComponent : children) {
            this.addChild(baseComponent);
        }
    }

    public void removeChild(BaseComponent child) {
        this._removeChild(child, false, false);
    }

    void _removeChild(BaseComponent child, boolean noSync, boolean destroy) {
        int index = this.children.indexOf(child);
        if (index == -1) {
            throw new ComponentException(this, "Child does not belong to this parent", new Object[0]);
        }
        this.beforeRemoveChild(child);
        this.nameIndex.remove(child);
        child.parent = null;
        this.children.remove(child);
        if (!noSync) {
            this.invokeIfAttached("removeChild", child, destroy);
        }
        child.dead |= destroy;
        this.afterRemoveChild(child);
    }

    public void swapChildren(int index1, int index2) {
        BaseComponent child1 = this.children.get(index1);
        BaseComponent child2 = this.children.get(index2);
        this.children.set(index1, child2);
        this.children.set(index2, child1);
        this.invokeIfAttached("swapChildren", index1, index2);
    }

    protected void beforeSetParent(BaseComponent newParent) {
    }

    protected void afterSetParent(BaseComponent oldParent) {
    }

    protected void beforeAddChild(BaseComponent child) {
    }

    protected void afterAddChild(BaseComponent child) {
    }

    protected void beforeRemoveChild(BaseComponent child) {
    }

    protected void afterRemoveChild(BaseComponent child) {
    }

    public List<BaseComponent> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public <T extends BaseComponent> Iterable<T> getChildren(Class<T> type) {
        return MiscUtil.iterableForType(this.getChildren(), type);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getChildCount(Class<? extends BaseComponent> type) {
        int count = 0;
        for (BaseComponent child : this.children) {
            if (!type.isInstance(child)) continue;
            ++count;
        }
        return count;
    }

    public boolean isContainer() {
        return this.componentDefinition.childrenAllowed();
    }

    public <T extends BaseComponent> T getChild(Class<T> type) {
        for (BaseComponent child : this.getChildren()) {
            if (!type.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public BaseComponent getChildAt(int index) {
        return index < 0 || index >= this.children.size() ? null : this.children.get(index);
    }

    public BaseComponent getFirstChild() {
        return this.getChildAt(0);
    }

    public BaseComponent getLastChild() {
        return this.getChildAt(this.getChildCount() - 1);
    }

    public BaseComponent getRoot() {
        BaseComponent root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public <T extends BaseComponent> T getAncestor(Class<T> type) {
        return (T)((BaseComponent)this.getAncestor(type, false));
    }

    public <T> T getAncestor(Class<T> type, boolean includeSelf) {
        BaseComponent cmp;
        BaseComponent baseComponent = cmp = includeSelf ? this : this.getParent();
        while (cmp != null && !type.isInstance(cmp)) {
            cmp = cmp.getParent();
        }
        return (T)cmp;
    }

    public boolean isAncestor(BaseComponent comp) {
        while (comp != null && comp != this) {
            comp = comp.getParent();
        }
        return comp != null;
    }

    public int getIndex() {
        return this.getParent() == null ? -1 : this.getParent().children.indexOf(this);
    }

    public void setIndex(int index) {
        this.getParent().addChild(this, index);
    }

    public BaseComponent getNextSibling() {
        return this.getRelativeSibling(1);
    }

    public BaseComponent getPreviousSibling() {
        return this.getRelativeSibling(-1);
    }

    private BaseComponent getRelativeSibling(int offset) {
        int i = this.getIndex();
        i = i == -1 ? -1 : i + offset;
        return i < 0 || i >= this.getParent().getChildCount() ? null : this.getParent().children.get(i);
    }

    public BaseComponent getNamespace() {
        for (BaseComponent comp = this; comp != null; comp = comp.getParent()) {
            if (!comp.isNamespace()) continue;
            return comp;
        }
        return null;
    }

    @Component.PropertyGetter(value="namespace", description="When true, this component acts as a namespace boundary.")
    public boolean isNamespace() {
        return this.namespace;
    }

    @Component.PropertySetter(value="namespace", description="When true, this component acts as a namespace boundary.")
    private void setNamespace(boolean namespace) {
        this.namespace = namespace;
    }

    public Page getPage() {
        return this.page;
    }

    private void _setPage(Page page) {
        this.validatePage(page);
        this.page = page;
        page.registerComponent(this, true);
        HashMap<String, Object> props = new HashMap<String, Object>();
        this._initProps(props);
        page.getSynchronizer().createWidget(this.parent, props, this.inits);
        this.inits = null;
        for (BaseComponent child : this.getChildren()) {
            child._setPage(page);
        }
    }

    protected void onAttach(Page page) {
    }

    protected void validatePage(Page page) {
        if (page != this.page && this.page != null) {
            throw new ComponentException(this, "Component cannot be assigned to a different page", new Object[0]);
        }
    }

    protected void _attach(Page page) {
        if (page != null && this.page != page) {
            this._setPage(page);
            this._flushQueue();
        }
    }

    private void _flushQueue() {
        if (this.invocationQueue != null) {
            this.page.getSynchronizer().processQueue(this.invocationQueue);
            this.invocationQueue = null;
        }
        for (BaseComponent child : this.getChildren()) {
            child._flushQueue();
        }
        this.onAttach(this.page);
        this.fireEvent("attach");
    }

    protected void _initProps(Map<String, Object> props) {
        props.put("id", this.id);
        props.put("wclass", this.componentDefinition.getWidgetClass());
        props.put("wmodule", this.componentDefinition.getWidgetModule());
        props.put("cntr", this.isContainer());
        props.put("nmsp", this.isNamespace() ? Boolean.valueOf(true) : null);
    }

    protected void sync(String state, Object value) {
        if (!this.dead) {
            if (this.getPage() == null) {
                if (this.inits == null) {
                    this.inits = new HashMap<String, Object>();
                }
                this.inits.put(state, value);
            } else {
                this.page.getSynchronizer().invokeClient(this, "updateState", state, value, true);
            }
        }
    }

    public void invoke(String function, Object ... args) {
        if (!this.dead) {
            this.invoke(this, function, args);
        }
    }

    public void invokeIfAttached(String function, Object ... args) {
        if (this.page != null) {
            this.invoke(function, args);
        }
    }

    public void invoke(IElementIdentifier id, String function, Object ... args) {
        ClientInvocation invocation = new ClientInvocation(id, function, args);
        if (this.page == null) {
            if (this.invocationQueue == null) {
                this.invocationQueue = new ClientInvocationQueue();
            }
            this.invocationQueue.queue(invocation);
        } else {
            this.page.getSynchronizer().sendToClient(invocation);
        }
    }

    public BaseComponent findByName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        String[] pcs = name.split("\\.");
        BaseComponent cmp = this;
        int i = 0;
        while (i < pcs.length && cmp != null) {
            String pc;
            if ("^".equals(pc = pcs[i++])) {
                cmp = cmp.getNamespace();
                if (i == pcs.length) continue;
                cmp = cmp == null ? null : cmp.getParent();
                cmp = cmp == null ? null : cmp.getNamespace();
                continue;
            }
            cmp = cmp.nameIndex.find(pc);
        }
        return cmp;
    }

    public <T extends BaseComponent> T findByName(String name, Class<T> type) {
        return (T)this.findByName(name);
    }

    public BaseComponent findChildByData(Object data) {
        for (BaseComponent child : this.children) {
            if (!ObjectUtils.equals((Object)data, (Object)child.getData())) continue;
            return child;
        }
        return null;
    }

    public BaseComponent findChildByLabel(String label) {
        for (BaseComponent comp : this.getChildren()) {
            if (!(comp instanceof ILabeled) || !label.equals(((ILabeled)((Object)comp)).getLabel())) continue;
            return comp;
        }
        return null;
    }

    public SubComponent sub(String subId) {
        return new SubComponent(this, subId);
    }

    @Component.PropertySetter(value="forward", defer=true, description="Sets one or more event forwarding directives.")
    private void setForward(String forwards) {
        if ((forwards = this.trimify(forwards)) != null) {
            for (String forward : forwards.split("\\ ")) {
                BaseComponent target;
                if (forward.isEmpty()) continue;
                int i = forward.indexOf("=");
                if (i <= 0) {
                    throw new IllegalArgumentException("Illegal forward directive:  " + forward);
                }
                String original = forward.substring(0, i);
                String name = (i = (forward = forward.substring(i + 1)).lastIndexOf(".")) == -1 ? null : forward.substring(0, i);
                forward = forward.substring(i + 1);
                BaseComponent baseComponent = target = name == null ? this : this.findByName(name);
                if (target == null) {
                    throw new ComponentException(this, "No component named \"%s\" found", name);
                }
                if (forward.isEmpty()) {
                    throw new IllegalArgumentException("No forward event specified");
                }
                this.addEventForward(original, target, forward);
            }
        }
    }

    public void addEventForward(String eventType, BaseComponent target) {
        this.addEventForward(eventType, target, null);
    }

    public void addEventForward(String eventType, BaseComponent target, String forwardType) {
        this.addEventListener(eventType, (IEventListener)this.createForwardListener(eventType, target, forwardType));
    }

    public void addEventForward(Class<? extends Event> eventClass, BaseComponent target) {
        this.addEventForward(eventClass, target, null);
    }

    public void addEventForward(Class<? extends Event> eventClass, BaseComponent target, String forwardType) {
        this.addEventForward(this.getEventType(eventClass), target, forwardType);
    }

    public void removeEventForward(String eventType, BaseComponent target) {
        this.removeEventForward(eventType, target, null);
    }

    public void removeEventForward(String eventType, BaseComponent target, String forwardType) {
        this.removeEventListener(eventType, (IEventListener)this.createForwardListener(eventType, target, forwardType));
    }

    public void removeEventForward(Class<? extends Event> eventClass, BaseComponent target) {
        this.removeEventForward(eventClass, target, null);
    }

    public void removeEventForward(Class<? extends Event> eventClass, BaseComponent target, String forwardType) {
        this.removeEventForward(this.getEventType(eventClass), target, forwardType);
    }

    private ForwardListener createForwardListener(String eventType, BaseComponent target, String forwardType) {
        return new ForwardListener(forwardType == null ? eventType : forwardType, target == null ? this : target);
    }

    public boolean hasEventListener(String eventType) {
        return this.eventListeners.hasListeners(eventType);
    }

    public boolean hasEventListener(Class<? extends Event> eventClass) {
        return this.hasEventListener(this.getEventType(eventClass));
    }

    public void addEventListener(String eventType, IEventListener eventListener) {
        this.updateEventListener(eventType, eventListener, true, true);
    }

    public void addEventListener(Class<? extends Event> eventClass, IEventListener eventListener) {
        this.updateEventListener(eventClass, eventListener, true, true);
    }

    public void addEventListener(String eventType, IEventListener eventListener, boolean syncToClient) {
        this.updateEventListener(eventType, eventListener, true, syncToClient);
    }

    public void addEventListener(Class<? extends Event> eventClass, IEventListener eventListener, boolean syncToClient) {
        this.updateEventListener(eventClass, eventListener, true, syncToClient);
    }

    public void removeEventListener(String eventType, IEventListener eventListener) {
        this.updateEventListener(eventType, eventListener, false, true);
    }

    public void removeEventListener(Class<? extends Event> eventClass, IEventListener eventListener) {
        this.updateEventListener(eventClass, eventListener, false, true);
    }

    public void removeEventListener(String eventType, IEventListener eventListener, boolean syncToClient) {
        this.updateEventListener(eventType, eventListener, false, syncToClient);
    }

    public void removeEventListener(Class<? extends Event> eventClass, IEventListener eventListener, boolean syncToClient) {
        this.updateEventListener(eventClass, eventListener, false, syncToClient);
    }

    private void updateEventListener(Class<? extends Event> eventClass, IEventListener eventListener, boolean register, boolean syncToClient) {
        this.updateEventListener(this.getEventType(eventClass), eventListener, register, syncToClient);
    }

    private void updateEventListener(String eventTypes, IEventListener eventListener, boolean register, boolean syncToClient) {
        for (String eventType : eventTypes.split("\\ ")) {
            eventType = EventUtil.stripOn(eventType);
            boolean before = this.eventListeners.hasListeners(eventType);
            if (register) {
                this.eventListeners.add(eventType, eventListener);
            } else {
                this.eventListeners.remove(eventType, eventListener);
            }
            if (!syncToClient || before == this.eventListeners.hasListeners(eventType)) continue;
            this.syncEventListeners(eventType, before);
        }
    }

    private void syncEventListeners(String eventType, boolean remove) {
        this.invoke("forwardToServer", eventType, remove);
    }

    private String getEventType(Class<? extends Event> eventClass) {
        String eventType = EventUtil.getEventType(eventClass);
        if (eventType == null) {
            throw new IllegalArgumentException("Not a concrete event type: " + eventClass);
        }
        return eventType;
    }

    public void fireEvent(String eventType) {
        this.fireEvent(EventUtil.toEvent(eventType));
    }

    public void fireEvent(Event event) {
        this.eventListeners.invoke(event);
    }

    @Component.PropertySetter(value="on:")
    private void setOnHandler(String eventName, Object value) {
        BaseScriptComponent script;
        if (value instanceof IEventListener) {
            this.addEventListener(eventName, (IEventListener)value);
            return;
        }
        if (value instanceof BaseScriptComponent) {
            script = (BaseScriptComponent)value;
        } else if (value instanceof String) {
            script = new ServerScript("groovy", value.toString());
            script.setMode(BaseScriptComponent.ExecutionMode.MANUAL);
        } else {
            throw new ComponentException(this, "Illegal type (%s) for event handler \"%s\"", value.getClass(), eventName);
        }
        this.addEventListener(eventName, (Event event) -> {
            if (script.getPage() == null) {
                script.setParent(this.getPage());
            } else {
                script.validatePage(this.getPage());
            }
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put(script.getSelf(), this);
            variables.put(ATTR_CONTROLLER, this.findAttribute(ATTR_CONTROLLER));
            variables.put("event", event);
            script.execute(variables);
        });
    }

    public void notifyAncestors(Event event, boolean includeThis) {
        BaseComponent next;
        BaseComponent baseComponent = next = includeThis ? this : this.getParent();
        while (next != null && !event.isStopped()) {
            next.fireEvent(event);
            next = next.getParent();
        }
    }

    public void notifyDescendants(Event event, boolean includeThis) {
        for (BaseComponent child : this.children) {
            child.notifyDescendants(event, true);
        }
        if (includeThis && !event.isStopped()) {
            this.fireEvent(event);
        }
    }

    @Component.PropertySetter(value="controller", defer=true, description="Controller to be wired to this component.")
    public void wireController(Object controller) {
        if (controller == null) {
            throw new ComponentException("Controller is null or could not be resolved.", new Object[0]);
        }
        if (controller instanceof String) {
            try {
                controller = "self".equals(controller) ? this : Class.forName((String)controller);
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }
        if (controller instanceof Class) {
            try {
                controller = ((Class)controller).newInstance();
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }
        this.setAttribute(ATTR_CONTROLLER, controller);
        WiredComponentScanner.wire(controller, this);
        EventHandlerScanner.wire(controller, this);
        this.controllers = this.controllers == null ? new ArrayList() : this.controllers;
        this.controllers.add(controller);
        if (controller instanceof IAutoWired) {
            ((IAutoWired)controller).afterInitialized(this);
        }
    }

    public List<Object> getControllers() {
        return this.controllers == null ? Collections.emptyList() : Collections.unmodifiableList(this.controllers);
    }

    public Object getController() {
        return this.controllers == null ? null : this.controllers.get(this.controllers.size() - 1);
    }

    public void bringToFront() {
        if (this.getParent() != null) {
            this.getParent().bringToFront();
        }
    }

    protected String nullify(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    protected String trimify(String value) {
        return value == null ? null : this.nullify(value.trim());
    }

    protected <T> T defaultify(T value, T deflt) {
        return value == null ? deflt : value;
    }

    protected boolean areEqual(Object obj1, Object obj2) {
        return ObjectUtils.equals((Object)obj1, (Object)obj2);
    }

    @Component.PropertyGetter(value="data", description="Data object to associate with this component.")
    public Object getData() {
        return this.data;
    }

    public <T> T getData(Class<T> type) {
        return (T)(type.isInstance(this.data) ? this.data : null);
    }

    @Component.PropertySetter(value="data", description="Data object to associate with this component.")
    public void setData(Object data) {
        this.data = data;
    }

    @Component.PropertyGetter(value="#text")
    protected String getContent() {
        return this.content;
    }

    @Component.PropertySetter(value="#text")
    protected void setContent(String content) {
        this.content = this.nullify(content);
        this.propertyChange("content", this.content, this.content, this.contentSynced);
    }

    protected boolean isContentSynced() {
        return this.contentSynced;
    }

    protected void setContentSynced(boolean contentSynced) {
        this.contentSynced = contentSynced;
    }

    @EventHandler(value={"statechange"}, syncToClient=false)
    private void _onStateChange(StatechangeEvent event) {
        String state = event.getState();
        try {
            Field field = FieldUtils.getField(this.getClass(), (String)state, (boolean)true);
            Object oldValue = field.get(this);
            Object newValue = ConvertUtil.convert(event.getValue(), field.getType(), this);
            field.set(this, newValue);
            this.propertyChange(state, oldValue, newValue, false);
        }
        catch (Exception e) {
            throw new ComponentException((Throwable)e, "Error updating state: " + state, new Object[0]);
        }
    }

    protected boolean propertyChange(String propertyName, Object oldValue, Object newValue, boolean syncToClient) {
        if (this.areEqual(oldValue, newValue)) {
            return false;
        }
        if (syncToClient) {
            this.sync(propertyName, newValue);
        }
        if (this.hasEventListener("propertychange")) {
            this.fireEvent(new PropertychangeEvent(this, propertyName, oldValue, newValue));
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(", ").append("id: ").append(this.id).append(", ").append("name: ").append(this.name);
        return sb.toString();
    }

    private class NameIndex {
        private Map<String, BaseComponent> names;

        private NameIndex() {
        }

        public void add(BaseComponent component) {
            String name = component.getName();
            if (name != null) {
                this.names = this.names == null ? new HashMap() : this.names;
                this.names.put(name, component);
            }
        }

        public void remove(BaseComponent component) {
            String name = component.getName();
            if (name != null && this.names != null) {
                this.names.remove(name);
            }
        }

        private BaseComponent _get(String name) {
            return this.names == null ? null : this.names.get(name);
        }

        public void validate(BaseComponent component) {
            this._validate(component, this.getNameRoot());
        }

        private void _validate(BaseComponent component, BaseComponent root) {
            this._validate(component.getName(), root, component);
            if (!component.isNamespace()) {
                for (BaseComponent child : component.getChildren()) {
                    this._validate(child, root);
                }
            }
        }

        private void validate(String name) {
            this._validate(name, this.getNameRoot(), null);
        }

        private void _validate(String name, BaseComponent root, BaseComponent component) {
            BaseComponent cmp;
            if (name != null && (cmp = this._find(name, root)) != null && cmp != component) {
                throw new ComponentException("Name \"" + name + "\"already exists in current namespace", new Object[0]);
            }
        }

        private BaseComponent getNameRoot() {
            BaseComponent root = BaseComponent.this.getNamespace();
            return root == null ? BaseComponent.this.getRoot() : root;
        }

        public BaseComponent find(String name) {
            return this._find(name, this.getNameRoot());
        }

        private BaseComponent _find(String name, BaseComponent root) {
            BaseComponent component = root.nameIndex._get(name);
            if (component != null) {
                return component;
            }
            for (BaseComponent child : root.getChildren()) {
                if (!child.isNamespace() && (component = this._find(name, child)) != null) break;
            }
            return component;
        }
    }

    public static class SubComponent
    implements IElementIdentifier {
        private final BaseComponent component;
        private final String subId;

        private SubComponent(BaseComponent component, String subId) {
            this.component = component;
            this.subId = subId;
        }

        @Override
        public String getId() {
            return this.component.getId() + "-" + this.subId;
        }
    }
}

