/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseLabeledComponent;
import org.fujion.component.BaseLabeledImageComponent;
import org.fujion.component.Combobox;
import org.fujion.event.ChangeEvent;
import org.fujion.event.EventUtil;

@Component(tag="comboitem", widgetClass="Comboitem", parentTag={"combobox"}, description="A single item within a combo box.")
public class Comboitem
extends BaseLabeledImageComponent<BaseLabeledComponent.LabelPositionNone> {
    private boolean selected;
    private String value;

    public Comboitem() {
    }

    public Comboitem(String label) {
        super(label);
    }

    public Comboitem(String label, String image) {
        super(label, image);
    }

    @Component.PropertyGetter(value="selected", description="The selection state.")
    public boolean isSelected() {
        return this.selected;
    }

    @Component.PropertySetter(value="selected", defaultValue="false", description="The selection state.")
    public void setSelected(boolean selected) {
        this._setSelected(selected, true, true);
    }

    @Component.PropertyGetter(value="value", description="The value associated with the combo item.")
    public String getValue() {
        return this.value;
    }

    @Component.PropertySetter(value="value", description="The value associated with the combo item.")
    public void setValue(String value) {
        this.value = value;
        this.propertyChange("value", this.value, this.value, true);
    }

    protected void _setSelected(boolean selected, boolean notifyClient, boolean notifyParent) {
        this.selected = selected;
        if (this.propertyChange("selected", this.selected, this.selected, notifyClient) && notifyParent && this.getParent() != null) {
            this.getCombobox()._updateSelected(selected ? this : null);
        }
    }

    public Combobox getCombobox() {
        return (Combobox)this.getParent();
    }

    @EventHandler(value={"change"}, syncToClient=false)
    private void _onChange(ChangeEvent event) {
        this._setSelected(this.defaultify(event.getValue(Boolean.class), true), false, true);
        event = new ChangeEvent(this.getParent(), (BaseComponent)this, event.getData(), (Object)this.getLabel());
        EventUtil.send(event);
    }
}

