/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseUIComponent;
import org.fujion.event.ChangeEvent;
import org.springframework.util.Assert;

@Component(tag="slider", widgetClass="Slider", parentTag={"*"}, description="A slider component.")
public class Slider
extends BaseUIComponent {
    private Orientation orientation = Orientation.HORIZONTAL;
    private int value;
    private int maxvalue = 100;
    private int minvalue;
    private int step = 1;
    private boolean synced;

    @Component.PropertyGetter(value="value", description="The current value of the slider.")
    public int getValue() {
        return this.value;
    }

    @Component.PropertySetter(value="value", defaultValue="0", description="The current value of the slider.")
    public void setValue(int value) {
        this._setValue(value, true);
    }

    private void _setValue(int value, boolean notifyClient) {
        this.value = value;
        this.propertyChange("value", this.value, this.value, notifyClient);
    }

    @Component.PropertyGetter(value="maxvalue", description="The maximum allowable value.")
    public int getMaxValue() {
        return this.maxvalue;
    }

    @Component.PropertySetter(value="maxvalue", defaultValue="100", description="The maximum allowable value.")
    public void setMaxValue(int maxvalue) {
        this.maxvalue = maxvalue;
        this.propertyChange("maxvalue", this.maxvalue, this.maxvalue, true);
    }

    @Component.PropertyGetter(value="minvalue", description="The minimum allowable value.")
    public int getMinValue() {
        return this.minvalue;
    }

    @Component.PropertySetter(value="minvalue", defaultValue="0", description="The minimum allowable value.")
    public void setMinValue(int minvalue) {
        this.minvalue = minvalue;
        this.propertyChange("minvalue", this.minvalue, this.minvalue, true);
    }

    @Component.PropertyGetter(value="orientation", description="The orientation of the component.")
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Component.PropertySetter(value="orientation", defaultValue="horizontal", description="The orientation of the component.")
    public void setOrientation(Orientation orientation) {
        this.orientation = this.defaultify(orientation, Orientation.HORIZONTAL);
        this.propertyChange("orientation", (Object)this.orientation, (Object)this.orientation, true);
    }

    @Component.PropertyGetter(value="step", description="The amount of change in the current value when an arrow button is clicked.")
    public int getStep() {
        return this.step;
    }

    @Component.PropertySetter(value="step", defaultValue="1", description="The amount of change in the current value when an arrow button is clicked.")
    public void setStep(int step) {
        Assert.isTrue((step > 0 ? 1 : 0) != 0, (String)"Step value must be greater than zero.");
        this.step = step;
        this.propertyChange("step", this.step, this.step, true);
    }

    @Component.PropertyGetter(value="synchronized", description="If set to true, every change to the slider's value will be sent to the server. If false, only the final value will be sent.")
    public boolean getSynchronized() {
        return this.synced;
    }

    @Component.PropertySetter(value="synchronized", defaultValue="false", description="If set to true, every change to the slider's value will be sent to the server. If false, only the final value will be sent.")
    protected void setSynchronized(boolean synced) {
        this.synced = synced;
        this.propertyChange("synced", this.synced, this.synced, true);
    }

    @EventHandler(value={"change"}, syncToClient=false)
    private void _onChange(ChangeEvent event) {
        this._setValue(this.defaultify(event.getValue(Integer.class), this.value), false);
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

