/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.function.BooleanSupplier;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseLabeledComponent;
import org.fujion.component.BaseLabeledImageComponent;
import org.fujion.component.Tabview;
import org.fujion.event.ChangeEvent;
import org.fujion.event.Event;
import org.fujion.event.EventUtil;

@Component(tag="tab", widgetModule="fujion-tabview", widgetClass="Tab", content=Component.ContentHandling.AS_CHILD, parentTag={"tabview"}, childTag={@Component.ChildTag(value="*")}, description="A single tab in a tab view.")
public class Tab
extends BaseLabeledImageComponent<BaseLabeledComponent.LabelPositionNone> {
    private boolean closable;
    private boolean selected;
    private BooleanSupplier onCanClose;
    private int badgeCounter;

    public Tab() {
    }

    public Tab(String label) {
        super(label);
    }

    @Component.PropertyGetter(value="closable", description="True if the tab is closable. A closable tab has an icon that, when clicked, removes and destroys the tab.")
    public boolean isClosable() {
        return this.closable;
    }

    @Component.PropertySetter(value="closable", defaultValue="false", description="True if the tab is closable. A closable tab has an icon that, when clicked, removes and destroys the tab.")
    public void setClosable(boolean closable) {
        this.closable = closable;
        this.propertyChange("closable", this.closable, this.closable, true);
    }

    @Component.PropertyGetter(value="selected", description="The selection state of the tab.")
    public boolean isSelected() {
        return this.selected;
    }

    @Component.PropertySetter(value="selected", defaultValue="false", description="The selection state of the tab.")
    public void setSelected(boolean selected) {
        this._setSelected(selected, true);
    }

    @EventHandler(value={"change"}, syncToClient=false)
    private void _onChange(ChangeEvent event) {
        this._setSelected(this.defaultify(event.getValue(Boolean.class), true), true);
        event = new ChangeEvent(this.getParent(), event.getData(), (Object)this);
        EventUtil.send(event);
    }

    @EventHandler(value={"close"}, syncToClient=false)
    private void _onClose(Event event) {
        this.close();
    }

    protected void _setSelected(boolean selected, boolean notifyParent) {
        this.selected = selected;
        if (this.propertyChange("selected", this.selected, this.selected, true) && notifyParent && this.getParent() != null) {
            this.getTabview().setSelectedTab(selected ? this : null);
        }
    }

    public boolean close() {
        if (this.canClose()) {
            this.destroy();
            return true;
        }
        return false;
    }

    public boolean canClose() {
        return this.onCanClose == null || this.onCanClose.getAsBoolean();
    }

    public Tabview getTabview() {
        return (Tabview)this.getParent();
    }

    public BooleanSupplier getOnCanClose() {
        return this.onCanClose;
    }

    public void setOnCanClose(boolean canClose) {
        this.setOnCanClose(() -> canClose);
    }

    public void setOnCanClose(BooleanSupplier onCanClose) {
        this.onCanClose = onCanClose;
    }

    @Override
    public void bringToFront() {
        this.setSelected(true);
        super.bringToFront();
    }

    @EventHandler(value={"badge"})
    private void _onBadge(Event event) {
        int delta = (Integer)event.getData();
        if (delta != 0) {
            this.badgeCounter += delta;
            this.sync("badge", this.badgeCounter);
        }
    }
}

