/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;

@Component(tag="timer", widgetClass="Timer", parentTag={"*"}, description="A timer component.")
public class Timer
extends BaseComponent {
    private long interval;
    private int repeat = -1;
    private boolean running;

    @Component.PropertyGetter(value="interval", description="The timer interval in milliseconds.")
    public long getInterval() {
        return this.interval;
    }

    @Component.PropertySetter(value="interval", defaultValue="0", description="The timer interval in milliseconds.")
    public void setInterval(long interval) {
        this.interval = interval;
        this.propertyChange("interval", this.interval, this.interval, true);
    }

    @Component.PropertyGetter(value="repeat", description="The number of times the timer will fire additional events after the initial event.")
    public int getRepeat() {
        return this.repeat;
    }

    @Component.PropertySetter(value="repeat", defaultValue="-1", description="The number of times the timer will fire additional events after the initial event.")
    public void setRepeat(int repeat) {
        this.repeat = repeat;
        this.propertyChange("repeat", this.repeat, this.repeat, true);
    }

    @Component.PropertyGetter(value="running", description="True if the timer is running.")
    public boolean isRunning() {
        return this.running;
    }

    @Component.PropertySetter(value="running", defaultValue="false", description="True if the timer is running.")
    public void setRunning(boolean running) {
        if (this.interval > 0L) {
            this.running = running;
            this.propertyChange("running", this.running, this.running, true);
        }
    }

    public void start() {
        this.setRunning(true);
    }

    public void stop() {
        this.setRunning(false);
    }

    public void restart() {
        this.stop();
        this.start();
    }
}

