/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.Iterator;
import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseUIComponent;
import org.fujion.component.Treenode;
import org.fujion.model.IModelAndView;
import org.fujion.model.ISupportsModel;
import org.fujion.model.ModelAndView;

@Component(tag="treeview", widgetModule="fujion-treeview", widgetClass="Treeview", parentTag={"*"}, childTag={@Component.ChildTag(value="treenode")}, description="A component acting as a root for a hierarchical collection of nodes.")
public class Treeview
extends BaseUIComponent
implements Iterable<Treenode>,
ISupportsModel<Treenode> {
    private boolean showRoot;
    private boolean showLines = true;
    private boolean showToggles = true;
    private Treenode selectedNode;
    private final ModelAndView<Treenode, Object> modelAndView = new ModelAndView(this);

    @Component.PropertyGetter(value="showRoot", description="True if the tree root should be visible.")
    public boolean getShowRoot() {
        return this.showRoot;
    }

    @Component.PropertySetter(value="showRoot", defaultValue="false", description="True if the tree root should be visible.")
    public void setShowRoot(boolean showRoot) {
        this.showRoot = showRoot;
        this.propertyChange("showRoot", this.showRoot, this.showRoot, true);
    }

    @Component.PropertyGetter(value="showLines", description="True if lines connecting parent nodes to their children should be displayed.")
    public boolean getShowLines() {
        return this.showLines;
    }

    @Component.PropertySetter(value="showLines", defaultValue="true", description="True if lines connecting parent nodes to their children should be displayed.")
    public void setShowLines(boolean showLines) {
        this.showLines = showLines;
        this.propertyChange("showLines", this.showLines, this.showLines, true);
    }

    @Component.PropertyGetter(value="showToggles", description="True if expander icons should be displayed.")
    public boolean getShowToggles() {
        return this.showToggles;
    }

    @Component.PropertySetter(value="showToggles", defaultValue="true", description="True if expander icons should be displayed.")
    public void setShowToggles(boolean showToggles) {
        this.showToggles = showToggles;
        this.propertyChange("showToggles", this.showToggles, this.showToggles, true);
    }

    public void collapseAll() {
        this.expandOrCollapse(this, true);
    }

    public void expandAll() {
        this.expandOrCollapse(this, false);
    }

    private void expandOrCollapse(BaseComponent parent, boolean collapse) {
        for (BaseComponent child : parent.getChildren()) {
            ((Treenode)child).setCollapsed(collapse);
            this.expandOrCollapse(child, collapse);
        }
    }

    public Treenode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(Treenode selectedNode) {
        if (selectedNode == this.selectedNode) {
            return;
        }
        if (this.selectedNode != null) {
            this.selectedNode._setSelected(false, true, false);
        }
        this.selectedNode = selectedNode;
        if (selectedNode != null) {
            selectedNode._setSelected(true, true, false);
        }
    }

    @Override
    protected void afterRemoveChild(BaseComponent child) {
        if (child.isAncestor(this.selectedNode)) {
            this.selectedNode = null;
        }
    }

    @Override
    protected void afterAddChild(BaseComponent child) {
        Treenode selnode = this.findSelected((Treenode)child, null);
        if (selnode != null) {
            this.setSelectedNode(selnode);
        }
    }

    private Treenode findSelected(Treenode node, Treenode selnode) {
        if (node.isSelected()) {
            if (selnode != null) {
                selnode._setSelected(false, true, false);
            }
            selnode = node;
        }
        for (BaseComponent child : node.getChildren()) {
            selnode = this.findSelected((Treenode)child, selnode);
        }
        return selnode;
    }

    @Override
    public Iterator<Treenode> iterator() {
        return new Treenode.TreenodeIterator(this);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.modelAndView.destroy();
    }

    @Override
    public IModelAndView<Treenode, ?> getModelAndView() {
        return this.modelAndView;
    }
}

