/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.component.BaseUIComponent;
import org.springframework.util.Assert;

@Component(tag="upload", widgetModule="fujion-upload", widgetClass="Upload", parentTag={"*"}, description="A component for uploading files to the server.")
public class Upload
extends BaseUIComponent {
    private boolean multiple;
    private boolean progress;
    private String accept;
    private int maxsize = 0x6400000;

    @Component.PropertyGetter(value="multiple", description="True if multiple file uploads are allowed.")
    public boolean isMultiple() {
        return this.multiple;
    }

    @Component.PropertySetter(value="multiple", defaultValue="false", description="True if multiple file uploads are allowed.")
    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
        this.propertyChange("multiple", this.multiple, this.multiple, true);
    }

    @Component.PropertyGetter(value="accept", description="Specifier for acceptable file types.")
    public String getAccept() {
        return this.accept;
    }

    @Component.PropertySetter(value="accept", description="Specifier for acceptable file types.")
    public void setAccept(String accept) {
        this.accept = this.nullify(accept);
        this.propertyChange("accept", this.accept, this.accept, true);
    }

    @Component.PropertyGetter(value="maxsize", description="The maximum allowable file size, in bytes.")
    public int getMaxsize() {
        return this.maxsize;
    }

    @Component.PropertySetter(value="maxsize", defaultValue="104857600", description="The maximum allowable file size, in bytes.")
    public void setMaxsize(int maxsize) {
        Assert.isTrue((maxsize >= 0 ? 1 : 0) != 0, (String)"maxsize must be >= 0");
        this.maxsize = maxsize;
        this.propertyChange("_maxsize", this.maxsize, this.maxsize, true);
    }

    @Component.PropertyGetter(value="progress", description="If true, the uploader will fire UploadEvent events to report progress.")
    public boolean getProgress() {
        return this.progress;
    }

    @Component.PropertySetter(value="progress", defaultValue="false", description="If true, the uploader will fire UploadEvent events to report progress.")
    public void setProgress(boolean progress) {
        this.progress = progress;
        this.propertyChange("_progress", this.progress, this.progress, true);
    }

    public void abortAll() {
        this.invokeIfAttached("abortAll", new Object[0]);
    }

    public void abort(String filename) {
        this.invokeIfAttached("abort", filename);
    }

    public void bind(BaseUIComponent comp) {
        this.invoke("bind", comp);
    }

    public void unbind(BaseUIComponent comp) {
        this.invoke("unbind", comp);
    }

    public void clear() {
        this.invoke("clear", new Object[0]);
    }
}

