/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.event;

import org.fujion.component.BaseComponent;
import org.fujion.event.Event;
import org.fujion.event.EventUtil;
import org.fujion.event.ForwardedEvent;
import org.fujion.event.IEventListener;
import org.springframework.util.Assert;

public class ForwardListener
implements IEventListener {
    private final String forwardType;
    private final BaseComponent target;

    public ForwardListener(String forwardType, BaseComponent target) {
        this.forwardType = forwardType;
        Assert.notNull((Object)this.forwardType, (String)"A forward type must be specified.");
        this.target = target;
        Assert.notNull((Object)this.target, (String)"A forward target must be specified");
    }

    @Override
    public void onEvent(Event event) {
        if (event.getType().equals(this.forwardType)) {
            if (event.getTarget() != this.target) {
                EventUtil.send(event, this.target);
            }
        } else {
            ForwardedEvent newEvent = new ForwardedEvent(this.forwardType, event);
            EventUtil.send(newEvent, this.target);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ForwardListener) {
            ForwardListener fl = (ForwardListener)object;
            return fl.target == this.target && fl.forwardType.equals(this.forwardType);
        }
        return false;
    }
}

