/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.expression;

import java.util.List;
import org.fujion.taglib.TagLibrary;
import org.fujion.taglib.TagLibraryFunction;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.spel.support.ReflectiveMethodResolver;

public class ELMethodResolver
extends ReflectiveMethodResolver {
    public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        if (targetObject instanceof TagLibrary) {
            TagLibrary lib = (TagLibrary)((Object)targetObject);
            TagLibraryFunction function = lib.getFunction(name);
            if (function != null) {
                try {
                    targetObject = Class.forName(function.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new AccessException("Error evaluating " + function, (Exception)e);
                }
                name = function.getMethodName();
            } else {
                throw new AccessException("Unknown function \"" + name + "\" in tag library " + lib.getUri());
            }
        }
        return super.resolve(context, (Object)targetObject, name, argumentTypes);
    }
}

