/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ipc;

import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.component.Page;
import org.fujion.event.EventUtil;
import org.fujion.event.IEventListener;
import org.fujion.ipc.InvocationRequest;
import org.fujion.ipc.InvocationRequestQueueRegistry;

public class InvocationRequestQueue {
    private static final Log log = LogFactory.getLog(InvocationRequestQueue.class);
    private final Object target;
    private final Page page;
    private final String name;
    private final String eventName;
    private final InvocationRequest onClose;
    private boolean closed;
    private final IEventListener invocationListener = event -> this.invokeRequest((InvocationRequest)event.getData());

    public InvocationRequestQueue(String name, BaseComponent target, InvocationRequest onClose) {
        this(name, target.getPage(), target, onClose);
    }

    public InvocationRequestQueue(String name, Page page, Object target, InvocationRequest onClose) {
        this.name = name;
        this.target = target;
        this.page = page;
        this.onClose = onClose;
        this.eventName = "invoke_" + name;
        InvocationRequestQueueRegistry.getInstance().register(this);
        page.addEventListener(this.eventName, this.invocationListener);
    }

    public String getName() {
        return this.name;
    }

    private void invokeRequest(InvocationRequest request) {
        try {
            MethodUtils.invokeMethod((Object)this.target, (String)request.getMethodName(), (Object[])request.getArgs(), (Class[])MiscUtil.getParameterTypes((Object[])request.getArgs()));
        }
        catch (Exception e) {
            log.error((Object)"Remote invocation error.", (Throwable)e);
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            InvocationRequestQueueRegistry.getInstance().unregister(this);
            this.page.removeEventListener(this.eventName, this.invocationListener);
            if (this.onClose != null) {
                this.invokeRequest(this.onClose);
            }
        }
    }

    public void sendRequest(String methodName, Object ... args) {
        this.sendRequest(new InvocationRequest(methodName, args));
    }

    public void sendRequest(InvocationRequest request) {
        EventUtil.post(this.page, this.eventName, this.page, request);
    }

    public boolean isAlive() {
        if (!this.closed && this.page.isDead()) {
            this.close();
        }
        return !this.closed;
    }
}

