/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.IteratorUtils;
import org.fujion.model.IListModel;

public class ListModel<M>
implements IListModel<M> {
    private final List<M> list = new LinkedList<M>();
    private final List<IListModel.IListModelListener> listeners = new ArrayList<IListModel.IListModelListener>();

    public ListModel() {
    }

    public ListModel(Collection<M> list) {
        this.list.addAll(list);
    }

    @Override
    public void add(int index, M value) {
        this.list.add(index, value);
        this.fireEvent(IListModel.ListEventType.ADD, index, index);
    }

    @Override
    public boolean add(M value) {
        if (this.list.add(value)) {
            int i = this.list.size() - 1;
            this.fireEvent(IListModel.ListEventType.ADD, i, i);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends M> c) {
        return this.addAll(this.list.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends M> c) {
        int i = this.list.size();
        if (this.list.addAll(c)) {
            int delta = this.list.size() - i;
            this.fireEvent(IListModel.ListEventType.ADD, index, index + delta - 1);
            return true;
        }
        return false;
    }

    @Override
    public boolean addEventListener(IListModel.IListModelListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public void clear() {
        int i = this.list.size();
        if (i > 0) {
            this.list.clear();
            this.fireEvent(IListModel.ListEventType.DELETE, 0, i - 1);
        }
    }

    @Override
    public boolean contains(Object value) {
        return this.list.contains(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    private void fireEvent(IListModel.ListEventType type, int startIndex, int endIndex) {
        for (IListModel.IListModelListener listener : this.listeners) {
            listener.onListChange(type, startIndex, endIndex);
        }
    }

    @Override
    public M get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object value) {
        return this.list.indexOf(value);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<M> iterator() {
        return IteratorUtils.unmodifiableIterator(this.list.iterator());
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.list.lastIndexOf(value);
    }

    @Override
    public ListIterator<M> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<M> listIterator(int index) {
        return IteratorUtils.unmodifiableListIterator(this.list.listIterator(index));
    }

    @Override
    public M remove(int index) {
        M value = this.list.remove(index);
        this.fireEvent(IListModel.ListEventType.DELETE, index, index);
        return value;
    }

    @Override
    public boolean remove(Object value) {
        int i = this.list.indexOf(value);
        if (i >= 0) {
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.list.removeAll(c)) {
            this.fireEvent(IListModel.ListEventType.CHANGE, -1, -1);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRange(int start, int end) {
        this.validateIndex(start);
        this.validateIndex(end);
        boolean result = false;
        for (int i = end; i >= start; --i) {
            this.list.remove(i);
            result = true;
        }
        if (result) {
            this.fireEvent(IListModel.ListEventType.DELETE, start, end);
        }
        return result;
    }

    private void validateIndex(int index) {
        if (index < 0 || index >= this.list.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
    }

    @Override
    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public boolean removeEventListener(IListModel.IListModelListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.list.retainAll(c)) {
            this.fireEvent(IListModel.ListEventType.CHANGE, -1, -1);
            return true;
        }
        return false;
    }

    @Override
    public M set(int index, M value) {
        M result = this.list.set(index, value);
        if (result != value) {
            this.fireEvent(IListModel.ListEventType.REPLACE, index, index);
        }
        return result;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void sort(Comparator<? super M> comparator, boolean ascending) {
        comparator = comparator != null ? comparator : ComparatorUtils.NATURAL_COMPARATOR;
        comparator = ascending ? comparator : ComparatorUtils.reversedComparator((Comparator)comparator);
        boolean changed = false;
        Object[] a = this.list.toArray();
        Arrays.sort(a, comparator);
        for (int newIndex = 0; newIndex < a.length; ++newIndex) {
            int oldIndex = this.list.indexOf(a[newIndex]);
            changed |= oldIndex != newIndex;
            this.swap(newIndex, oldIndex);
        }
        if (changed) {
            this.fireEvent(IListModel.ListEventType.SORT, -1, -1);
        }
    }

    @Override
    public List<M> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void swap(int index1, int index2) {
        if (index1 != index2) {
            M item1 = this.list.get(index1);
            M item2 = this.list.get(index2);
            this.list.set(index1, item2);
            this.list.set(index2, item1);
            this.fireEvent(IListModel.ListEventType.SWAP, index1, index2);
        }
    }

    @Override
    public void swap(M item1, M item2) {
        this.swap(this.list.indexOf(item1), this.list.indexOf(item2));
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }
}

