/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.model;

import java.util.HashMap;
import java.util.Map;
import org.fujion.client.Synchronizer;
import org.fujion.component.BaseComponent;
import org.fujion.component.Page;
import org.fujion.model.IComponentRenderer;
import org.fujion.model.IListModel;
import org.fujion.model.IModelAndView;
import org.fujion.model.INestedModel;
import org.fujion.model.IPaginator;
import org.fujion.model.Paginator;

public class ModelAndView<T extends BaseComponent, M>
implements IListModel.IListModelListener,
IPaginator.IPagingListener,
IModelAndView<T, M> {
    private BaseComponent parent;
    private IComponentRenderer<T, M> renderer;
    private IListModel<M> model;
    private Map<BaseComponent, ModelAndView<T, M>> linkedViews;
    private boolean deferredRendering;
    private final Paginator paginator;

    public ModelAndView(BaseComponent parent) {
        this.parent = parent;
        this.paginator = new Paginator();
        this.paginator.addEventListener(this);
    }

    public ModelAndView(BaseComponent parent, IListModel<M> model, IComponentRenderer<T, M> renderer) {
        this(parent);
        this.setModel(model);
        this.setRenderer(renderer);
    }

    @Override
    public IComponentRenderer<T, M> getRenderer() {
        return this.renderer;
    }

    @Override
    public void setRenderer(IComponentRenderer<T, M> renderer) {
        if (renderer != this.renderer) {
            this.renderer = renderer;
            this.rerender();
        }
    }

    @Override
    public IListModel<M> getModel() {
        return this.model;
    }

    @Override
    public void setModel(IListModel<M> model) {
        if (this.model != null) {
            this.model.removeEventListener(this);
        }
        this.model = model;
        if (this.model != null) {
            this.model.addEventListener(this);
        }
        this.paginator.setModelSize(model == null ? 0 : model.size());
        this.rerender();
    }

    private Map<BaseComponent, ModelAndView<T, M>> getLinkedViews() {
        if (this.linkedViews == null) {
            this.linkedViews = new HashMap<BaseComponent, ModelAndView<T, M>>();
        }
        return this.linkedViews;
    }

    private int getChildIndex(int modelIndex) {
        if (this.paginator.isDisabled()) {
            return modelIndex;
        }
        return modelIndex - this.paginator.getModelOffset(this.paginator.getCurrentPage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rerender() {
        this.removeLinkedViews();
        if (this.parent != null) {
            this.parent.destroyChildren();
        }
        if (this.model != null && this.parent != null && this.renderer != null) {
            try {
                this.onRenderStart();
                int start = this.adjustIndex(0);
                int end = this.adjustIndex(this.model.size() - 1);
                for (int i = start; i <= end; ++i) {
                    this.renderChild(i);
                }
            }
            finally {
                this.onRenderStop();
            }
        }
    }

    protected void onRenderStart() {
        if (this.deferredRendering) {
            this.synchronizer(true);
        }
    }

    protected void onRenderStop() {
        if (this.deferredRendering) {
            this.synchronizer(false);
        }
    }

    private void synchronizer(boolean pause) {
        Synchronizer synchronizer;
        Page page = this.parent == null ? null : this.parent.getPage();
        Synchronizer synchronizer2 = synchronizer = page == null ? null : page.getSynchronizer();
        if (synchronizer != null) {
            if (pause) {
                synchronizer.startQueueing();
            } else {
                synchronizer.stopQueueing();
            }
        }
    }

    protected T renderChild(int modelIndex) {
        if (this.renderer != null && this.paginator.inRange(modelIndex)) {
            Object mdl = this.model.get(modelIndex);
            T child = this.renderer.render(mdl);
            this.parent.addChild((BaseComponent)child, this.getChildIndex(modelIndex));
            if (this.model instanceof INestedModel) {
                this.getLinkedViews().put((BaseComponent)child, new ModelAndView((BaseComponent)child, ((INestedModel)this.model).getChildren(mdl), this.renderer));
            }
            return child;
        }
        return null;
    }

    protected void destroyChild(int modelIndex) {
        if (this.paginator.inRange(modelIndex)) {
            ModelAndView<T, M> linkedView;
            BaseComponent child = this.parent.getChildAt(this.getChildIndex(modelIndex));
            ModelAndView<T, M> modelAndView = linkedView = this.linkedViews == null ? null : this.linkedViews.get(child);
            if (linkedView != null) {
                this.linkedViews.remove(child);
                linkedView.destroy();
            }
            child.destroy();
        }
    }

    private void removeLinkedViews() {
        if (this.linkedViews != null) {
            for (ModelAndView<T, M> linkedView : this.linkedViews.values()) {
                linkedView.destroy();
            }
            this.linkedViews.clear();
        }
    }

    public void destroy() {
        if (this.model != null) {
            this.model.removeEventListener(this);
        }
        this.paginator.removeAllListeners();
        this.removeLinkedViews();
        this.linkedViews = null;
        this.model = null;
        this.renderer = null;
        this.parent = null;
    }

    @Override
    public void onListChange(IListModel.ListEventType type, int startIndex, int endIndex) {
        this.paginator.setModelSize(this.model.size());
        switch (type) {
            case ADD: {
                startIndex = this.adjustIndex(startIndex);
                endIndex = this.adjustIndex(endIndex);
                for (int i = startIndex; i <= endIndex; ++i) {
                    this.renderChild(i);
                }
                break;
            }
            case DELETE: {
                startIndex = this.adjustIndex(startIndex);
                for (int i = endIndex = this.adjustIndex(endIndex); i >= startIndex; --i) {
                    this.destroyChild(i);
                }
                break;
            }
            case CHANGE: {
                this.rerender();
                break;
            }
            case REPLACE: {
                this.onListChange(IListModel.ListEventType.DELETE, startIndex, endIndex);
                this.onListChange(IListModel.ListEventType.ADD, startIndex, endIndex);
                break;
            }
            case SWAP: {
                if (!this.paginator.isDisabled()) break;
                this.parent.swapChildren(startIndex, endIndex);
                break;
            }
            case SORT: {
                if (this.paginator.isDisabled()) break;
                this.rerender();
            }
        }
    }

    private int adjustIndex(int modelIndex) {
        if (modelIndex < 0 || this.paginator.isDisabled()) {
            return modelIndex;
        }
        int page = this.paginator.getCurrentPage();
        int min = this.paginator.getModelOffset(page);
        int max = this.paginator.getModelOffset(page + 1) - 1;
        return modelIndex < min ? min : (modelIndex > max ? max : modelIndex);
    }

    @Override
    public T rerender(M object) {
        return this.rerender(this.model.indexOf(object));
    }

    @Override
    public T rerender(int modelIndex) {
        if (this.paginator.inRange(modelIndex)) {
            this.destroyChild(modelIndex);
            return this.renderChild(modelIndex);
        }
        return null;
    }

    @Override
    public boolean getDeferredRendering() {
        return this.deferredRendering;
    }

    @Override
    public void setDeferredRendering(boolean value) {
        this.deferredRendering = value;
    }

    @Override
    public IPaginator getPaginator() {
        return this.paginator;
    }

    @Override
    public void onPagingChange(IPaginator.PagingEventType type, int oldValue, int newValue) {
        if (type != IPaginator.PagingEventType.MAX_PAGE) {
            this.rerender();
        }
    }
}

