/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.model;

import java.util.ArrayList;
import java.util.List;
import org.fujion.model.IPaginator;
import org.springframework.util.Assert;

public class Paginator
implements IPaginator {
    private final List<IPaginator.IPagingListener> listeners = new ArrayList<IPaginator.IPagingListener>();
    private int pageSize;
    private int currentPage;
    private int modelSize;

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        if (pageSize != this.pageSize) {
            this.currentPage = 0;
            this.pageSize = pageSize;
            this.fireEvent(IPaginator.PagingEventType.PAGE_SIZE, this.pageSize, this.pageSize);
        }
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public void setCurrentPage(int pageIndex) {
        if (pageIndex != this.currentPage) {
            Assert.isTrue((pageIndex >= 0 ? 1 : 0) != 0, (String)"Current page may not be less than 0");
            Assert.isTrue((pageIndex <= this.getMaxPage() ? 1 : 0) != 0, (String)"Current page may not exceed maximum number of pages");
            this.currentPage = pageIndex;
            this.fireEvent(IPaginator.PagingEventType.CURRENT_PAGE, this.currentPage, this.currentPage);
        }
    }

    @Override
    public int getModelSize() {
        return this.modelSize;
    }

    public void setModelSize(int modelSize) {
        if (modelSize != this.modelSize) {
            Assert.isTrue((modelSize >= 0 ? 1 : 0) != 0, (String)"Model size must not be less than 0");
            int oldmax = this.getMaxPage();
            this.modelSize = modelSize;
            this.fireEvent(IPaginator.PagingEventType.MAX_PAGE, oldmax, this.getMaxPage());
        }
    }

    @Override
    public int getMaxPage() {
        return this.isDisabled() || this.modelSize == 0 ? 0 : (this.modelSize - 1) / this.pageSize;
    }

    public boolean inRange(int modelIndex) {
        return this.isDisabled() || modelIndex >= this.getModelOffset(this.currentPage) && modelIndex < this.getModelOffset(this.currentPage + 1);
    }

    public int getModelOffset(int pageIndex) {
        return this.isDisabled() ? 0 : Math.min(pageIndex * this.pageSize, this.modelSize);
    }

    @Override
    public boolean addEventListener(IPaginator.IPagingListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public boolean removeEventListener(IPaginator.IPagingListener listener) {
        return this.listeners.remove(listener);
    }

    private void fireEvent(IPaginator.PagingEventType type, int oldValue, int newValue) {
        for (IPaginator.IPagingListener listener : this.listeners) {
            listener.onPagingChange(type, oldValue, newValue);
        }
    }
}

