/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.model;

import java.util.Comparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.fujion.common.MiscUtil;

public class SmartComparator
implements Comparator<Object> {
    private final String name;
    private final boolean nullsFirst;
    private final boolean caseSensitive;
    private final boolean isField;

    public SmartComparator(String name) {
        this(name, true, false);
    }

    public SmartComparator(String name, boolean nullsFirst, boolean caseSensitive) {
        this.isField = name.startsWith("@");
        this.name = this.isField ? name.substring(1) : name;
        this.nullsFirst = nullsFirst;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public int compare(Object bean1, Object bean2) {
        Object value2;
        Object value1 = this.getValue(bean1);
        if (value1 == (value2 = this.getValue(bean2))) {
            return 0;
        }
        if (value1 == null) {
            return this.nullsFirst ? -1 : 1;
        }
        if (value2 == null) {
            return this.nullsFirst ? 1 : -1;
        }
        if (value1.getClass() != value2.getClass()) {
            return value1.hashCode() - value2.hashCode();
        }
        if (value1 instanceof String) {
            String s1 = (String)value1;
            String s2 = (String)value2;
            return this.caseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        }
        if (value1 instanceof Comparable) {
            return ((Comparable)value1).compareTo(value2);
        }
        if (value1 instanceof Integer) {
            return ((Integer)value1).compareTo((Integer)value2);
        }
        if (value1 instanceof Long) {
            return ((Long)value1).compareTo((Long)value2);
        }
        if (value1 instanceof Short) {
            return ((Short)value1).compareTo((Short)value2);
        }
        if (value1 instanceof Byte) {
            return ((Byte)value1).compareTo((Byte)value2);
        }
        if (value1 instanceof Float) {
            return ((Float)value1).compareTo((Float)value2);
        }
        if (value1 instanceof Double) {
            return ((Double)value1).compareTo((Double)value2);
        }
        return value1.hashCode() - value2.hashCode();
    }

    private Object getValue(Object bean) {
        try {
            return bean == null ? null : (this.isField ? this.getFieldValue(bean) : this.getPropertyValue(bean));
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    private Object getPropertyValue(Object bean) throws Exception {
        return PropertyUtils.getProperty((Object)bean, (String)this.name);
    }

    private Object getFieldValue(Object bean) throws Exception {
        return FieldUtils.readField((Object)bean, (String)this.name, (boolean)true);
    }
}

