/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.page;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.ancillary.ComponentRegistry;
import org.fujion.annotation.Component;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.common.RegistryMap;
import org.fujion.component.Content;
import org.fujion.core.WebUtil;
import org.fujion.page.PIParserBase;
import org.fujion.page.PageDefinition;
import org.fujion.page.PageElement;
import org.fujion.page.PageSource;
import org.fujion.page.ParserException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class PageParser
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(PageParser.class);
    private static final PageParser instance = new PageParser();
    public static final String CONTENT_ATTR = "#text";
    public static final String NS_FSP = "http://www.fujion.org/schema/fsp";
    public static final String NS_ON = "http://www.fujion.org/schema/fsp/on";
    public static final String NS_ATTR = "http://www.fujion.org/schema/fsp/attr";
    private final Map<String, String> attrNSMap = new HashMap<String, String>();
    private final Map<String, String> tagNSMap = new HashMap<String, String>();
    private final RegistryMap<String, PIParserBase> piParsers = new RegistryMap(RegistryMap.DuplicateAction.ERROR);

    public static PageParser getInstance() {
        return instance;
    }

    private PageParser() {
        this.attrNSMap.put(NS_ON, "on");
        this.attrNSMap.put(NS_ATTR, "attr");
        this.tagNSMap.put(NS_FSP, "");
    }

    public PageDefinition parse(String src) {
        return this.parse(WebUtil.getResource(src));
    }

    public PageDefinition parse(Resource resource) {
        return this.parse(new PageSource(resource));
    }

    public PageDefinition parse(InputStream stream) {
        return this.parse(new PageSource(stream));
    }

    protected PageDefinition parse(PageSource source) {
        PageDefinition pageDefinition = new PageDefinition();
        pageDefinition.setSource(source.getSource());
        this.parse(source, pageDefinition.getRootElement());
        return pageDefinition;
    }

    protected void parse(PageSource source, PageElement parentElement) {
        this.parseNode(source.getDocument(), parentElement);
    }

    private void parseNode(Node node, PageElement parentElement) {
        switch (node.getNodeType()) {
            case 1: {
                String tag = this.normalizeNodeName(node, this.tagNSMap);
                if (tag == null) break;
                if (tag.equals("fsp") && node.getParentNode() instanceof Document) {
                    this.parseChildren(node, parentElement);
                    return;
                }
                ComponentDefinition def = (ComponentDefinition)ComponentRegistry.getInstance().get(tag);
                if (def == null) {
                    throw new ParserException("Unrecognized tag  '<%s>'", tag);
                }
                PageElement childElement = new PageElement(def, parentElement);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attr = attributes.item(i);
                    String name = this.normalizeNodeName(attr, this.attrNSMap);
                    if (name == null) continue;
                    childElement.setAttribute(name, attr.getNodeValue());
                }
                this.parseChildren(node, childElement);
                childElement.validate();
                break;
            }
            case 3: 
            case 4: {
                String value = ((Text)node).getWholeText();
                if (value.trim().isEmpty()) break;
                ComponentDefinition parentDef = parentElement.getDefinition();
                switch (parentDef == null ? Component.ContentHandling.AS_CHILD : parentDef.contentHandling()) {
                    case ERROR: {
                        throw new ParserException("Text content is not allowed for tag '<%s>'", parentDef.getTag());
                    }
                    case IGNORE: {
                        break;
                    }
                    case AS_ATTRIBUTE: {
                        parentElement.setAttribute(CONTENT_ATTR, this.normalizeText(value));
                        break;
                    }
                    case AS_CHILD: {
                        ComponentDefinition def = ComponentRegistry.getInstance().get(Content.class);
                        PageElement childElement = new PageElement(def, parentElement);
                        childElement.setAttribute(CONTENT_ATTR, this.normalizeText(value));
                    }
                }
                break;
            }
            case 9: {
                this.parseChildren(node, parentElement);
                break;
            }
            case 8: {
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                PIParserBase piParser = (PIParserBase)this.piParsers.get((Object)pi.getTarget());
                if (piParser != null) {
                    piParser.parse(pi, parentElement);
                    break;
                }
                throw new ParserException("Unrecognized processing instruction \"%s\"", pi.getTarget());
            }
            default: {
                throw new ParserException("Unrecognized document content type \"%s\"", node.getNodeName());
            }
        }
    }

    private String normalizeNodeName(Node node, Map<String, String> nsMap) {
        String name = node.getNodeName();
        int i = name.indexOf(":");
        if (i > 0) {
            String pfx = name.substring(0, i);
            name = name.substring(i + 1);
            String uri = node.lookupNamespaceURI(pfx);
            name = (pfx = nsMap.get(uri)) == null ? null : (pfx.isEmpty() ? name : pfx + ":" + name);
        }
        return name;
    }

    private void parseChildren(Node node, PageElement parentElement) {
        NodeList children = node.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node childNode = children.item(i);
            this.parseNode(childNode, parentElement);
        }
    }

    private String normalizeText(String text) {
        int i = text.indexOf(10);
        if (i == -1) {
            return text;
        }
        if (text.substring(0, i).trim().isEmpty()) {
            text = text.substring(i + 1);
        }
        if ((i = text.lastIndexOf(10)) >= 0 && text.substring(i).trim().isEmpty()) {
            text = text.substring(0, i);
        }
        return text;
    }

    private void registerPIParser(PIParserBase piParser) {
        this.piParsers.put((Object)piParser.getTarget(), (Object)piParser);
        log.info((Object)("Registered processing instruction parser for target '" + piParser.getTarget() + "'."));
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof PIParserBase) {
            this.registerPIParser((PIParserBase)bean);
        }
        return bean;
    }
}

