/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.taglib;

import java.util.HashMap;
import java.util.Map;
import org.fujion.taglib.TagLibraryFunction;

public class TagLibrary {
    private final Map<String, TagLibraryFunction> functions = new HashMap<String, TagLibraryFunction>();
    private final String uri;

    public TagLibrary(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void addFunction(String functionName, String className, String methodSignature) {
        TagLibraryFunction newFunction = new TagLibraryFunction(className, methodSignature);
        TagLibraryFunction oldFunction = this.functions.get(functionName);
        if (oldFunction != null) {
            if (!oldFunction.equals(newFunction)) {
                throw new RuntimeException("Duplicate tag library function name: " + functionName);
            }
        } else {
            this.functions.put(functionName, newFunction);
        }
    }

    public TagLibraryFunction getFunction(String functionName) {
        return this.functions.get(functionName);
    }
}

