/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.taglib;

public class TagLibraryFunction {
    private final String className;
    private final String methodSignature;
    private final String methodName;

    TagLibraryFunction(String className, String methodSignature) {
        this.className = className.trim();
        this.methodSignature = methodSignature;
        this.methodName = this.extractMethodName(methodSignature);
    }

    private String extractMethodName(String methodSignature) {
        int i;
        int j = methodSignature.indexOf("(", i = methodSignature.indexOf(" "));
        return methodSignature.substring(i + 1, j < 0 ? methodSignature.length() : j).trim();
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String toString() {
        return this.className + "." + this.methodName;
    }

    public boolean equals(Object object) {
        if (object instanceof TagLibraryFunction) {
            TagLibraryFunction fcn = (TagLibraryFunction)object;
            return fcn.className.equals(this.className) && fcn.methodSignature.equals(this.methodSignature);
        }
        return false;
    }
}

