/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.websocket;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.client.ClientInvocation;
import org.fujion.client.ClientRequest;
import org.fujion.client.Synchronizer;
import org.fujion.component.Page;
import org.fujion.page.PageRegistry;
import org.fujion.websocket.ISessionListener;
import org.fujion.websocket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;

public class Session {
    private static final Log log = LogFactory.getLog(Session.class);
    public static final String ATTR_SESSION = "fujion_session";
    private final ServletContext servletContext;
    private final WebSocketSession socket;
    private final Synchronizer synchronizer;
    private Set<ISessionListener> sessionListeners;
    private final long creationTime;
    private long lastActivity;
    private Page page;

    protected Session(ServletContext servletContext, WebSocketSession socket) {
        this.servletContext = servletContext;
        this.socket = socket;
        socket.getAttributes().put(ATTR_SESSION, this);
        this.synchronizer = new Synchronizer(socket);
        this.lastActivity = this.creationTime = System.currentTimeMillis();
    }

    protected void destroy() {
        if (this.page != null) {
            try {
                this.synchronizer.startQueueing();
                this.page.destroy();
                this.socket.getAttributes().remove(ATTR_SESSION);
            }
            finally {
                this.page = null;
            }
        }
        this.notifySessionListeners(EventType.DESTROY, null);
    }

    public String getId() {
        return this.socket.getId();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public void updateLastActivity() {
        this.lastActivity = System.currentTimeMillis();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public WebSocketSession getSocket() {
        return this.socket;
    }

    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public Page getPage() {
        return this.page;
    }

    public Map<String, Object> getAttributes() {
        return this.socket.getAttributes();
    }

    public boolean addSessionListener(ISessionListener listener) {
        if (this.sessionListeners == null) {
            this.sessionListeners = new LinkedHashSet<ISessionListener>();
        }
        return this.sessionListeners.add(listener);
    }

    public boolean removeSessionListener(ISessionListener listener) {
        return this.sessionListeners != null && this.sessionListeners.remove(listener);
    }

    protected void notifySessionListeners(ClientRequest request) {
        this.notifySessionListeners(EventType.REQUEST, request);
    }

    protected void notifySessionListeners(ClientInvocation invocation) {
        this.notifySessionListeners(EventType.INVOCATION, invocation);
    }

    private void notifySessionListeners(EventType event, Object argument) {
        if (this.sessionListeners != null) {
            for (ISessionListener sessionListener : this.sessionListeners) {
                try {
                    switch (event) {
                        case DESTROY: {
                            sessionListener.onDestroy();
                            break;
                        }
                        case REQUEST: {
                            sessionListener.onClientRequest((ClientRequest)argument);
                            break;
                        }
                        case INVOCATION: {
                            sessionListener.onClientInvocation((ClientInvocation)argument);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"A session listener threw an exception", (Throwable)e);
                }
            }
        }
    }

    public void ping(String data) {
        WebSocketHandler.send(this.socket, new ClientInvocation((String)null, "fujion.ws.ping", data));
    }

    protected boolean _init(String pageId) {
        if (this.page != null) {
            if (!this.page.getId().equals(pageId)) {
                throw new RuntimeException("Page ids do not match.");
            }
            return false;
        }
        this.page = PageRegistry.getPage(pageId);
        if (this.page == null) {
            throw new RuntimeException("Unknown page id.");
        }
        return true;
    }

    private static enum EventType {
        DESTROY,
        REQUEST,
        INVOCATION;

    }
}

