/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.websocket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.websocket.ISessionLifecycle;
import org.fujion.websocket.Session;
import org.fujion.websocket.SessionInitException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketSession;

public class Sessions
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(Sessions.class);
    private static final Sessions instance = new Sessions();
    private final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    private final Set<ISessionLifecycle> lifecycleListeners = new HashSet<ISessionLifecycle>();

    public static Sessions getInstance() {
        return instance;
    }

    private Sessions() {
    }

    public Collection<Session> getActiveSessions() {
        return Collections.unmodifiableCollection(this.sessions.values());
    }

    public void addLifecycleListener(ISessionLifecycle listener) {
        this.lifecycleListeners.add(listener);
    }

    public void removeLifecycleListener(ISessionLifecycle listener) {
        this.lifecycleListeners.remove(listener);
    }

    protected void notifyLifecycleListeners(Session session, boolean created) {
        if (!this.lifecycleListeners.isEmpty()) {
            for (ISessionLifecycle listener : new ArrayList<ISessionLifecycle>(this.lifecycleListeners)) {
                try {
                    if (created) {
                        listener.onSessionCreate(session);
                        continue;
                    }
                    listener.onSessionDestroy(session);
                }
                catch (Exception e) {
                    if (created && e instanceof SessionInitException) {
                        throw e;
                    }
                    log.error((Object)"A session lifecycle listener threw an exception.", (Throwable)e);
                }
            }
        }
    }

    public Session getSession(String id) {
        return this.sessions.get(id);
    }

    protected Session createSession(ServletContext servletContext, WebSocketSession socket) {
        Session session = new Session(servletContext, socket);
        this.sessions.put(session.getId(), session);
        if (log.isDebugEnabled()) {
            this.logSessionEvent(session, "established");
        }
        return session;
    }

    protected void destroySession(WebSocketSession socket, CloseStatus status) {
        Session session = this.sessions.remove(socket.getId());
        if (session != null) {
            if (log.isDebugEnabled()) {
                this.logSessionEvent(session, "closed, " + status);
            }
            this.notifyLifecycleListeners(session, false);
            session.destroy();
        }
    }

    private void logSessionEvent(Session session, String event) {
        log.debug((Object)("Session #" + session.getId() + " " + event + "."));
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ISessionLifecycle) {
            this.addLifecycleListener((ISessionLifecycle)bean);
        }
        return bean;
    }
}

