/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import java.lang.reflect.Method;
import java.util.Map;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.annotation.Component;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.expression.ELEvaluator;

public class ComponentFactory {
    private final ComponentDefinition def;
    private Class<? extends BaseComponent> clazz;
    private boolean inactive;

    public ComponentFactory(ComponentDefinition def) {
        this.def = def;
        this.clazz = def.getComponentClass();
    }

    @Component.FactoryParameter(value="impl", description="Component implementation class to substitute.")
    protected void setImplementationClass(Class<? extends BaseComponent> clazz) {
        Class<? extends BaseComponent> originalClazz = this.def.getComponentClass();
        if (clazz != null && !originalClazz.isAssignableFrom(clazz)) {
            throw new ComponentException("Implementation class must extend class " + originalClazz.getName(), new Object[0]);
        }
        this.clazz = clazz;
    }

    @Component.FactoryParameter(value="if", description="If false, prevent component creation.")
    protected void setIf(boolean condition) {
        this.inactive = !condition;
    }

    @Component.FactoryParameter(value="unless", description="If true, prevent component creation.")
    protected void setUnless(boolean condition) {
        this.inactive = condition;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public BaseComponent create(Map<String, String> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, Method> entry : this.def.getFactoryParameters().entrySet()) {
                String name = entry.getKey();
                if (!attributes.containsKey(name)) continue;
                Object value = ELEvaluator.getInstance().evaluate(attributes.remove(name));
                ConvertUtil.invokeMethod(this, entry.getValue(), value);
            }
        }
        try {
            return this.inactive ? null : this.clazz.newInstance();
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }
}

