/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.common.MiscUtil;
import org.springframework.util.Assert;

public class DeferredInvocation<T> {
    private final Object instance;
    private final Method method;
    private final List<Object> curriedArgs = new ArrayList<Object>();

    public DeferredInvocation(Object instance, Method method, Object ... curriedArgs) {
        this.instance = instance;
        this.method = method;
        this.addArgs(curriedArgs);
        method.setAccessible(true);
    }

    public void addArgs(Object ... args) {
        if (args != null) {
            Assert.isTrue((this.curriedArgs.size() + args.length <= this.method.getParameterCount() ? 1 : 0) != 0, (String)"Method parameter count was exceeded");
            this.curriedArgs.addAll(Arrays.asList(args));
        }
    }

    public T invoke(Object ... args) {
        try {
            ArrayList<Object> arguments = new ArrayList<Object>(this.curriedArgs);
            arguments.addAll(Arrays.asList(args));
            return (T)ConvertUtil.invokeMethod(this.instance, this.method, arguments.toArray());
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }
}

