/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.fujion.ancillary.ComponentRegistry;
import org.fujion.annotation.Component;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.annotation.ComponentScanner;
import org.fujion.common.StrUtil;
import org.fujion.common.Version;
import org.fujion.common.XMLUtil;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SchemaGenerator {
    private static final String NS_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String NS_VERSIONING = "http://www.w3.org/2007/XMLSchema-versioning";
    private static final String UNBOUNDED = "unbounded";
    private final Document schema;
    private final Element root;

    public static void main(String ... args) throws Exception {
        String output;
        Options options = new Options();
        Option option = new Option("p", "packages", true, "Java package(s) to scan");
        option.setArgs(-2);
        options.addOption(option);
        option = new Option("c", "classes", true, "Java class(es) to scan");
        option.setArgs(-2);
        options.addOption(option);
        option = new Option("v", "version", true, "Schema version");
        options.addOption(option);
        option = new Option("t", "title", true, "Title for schema documentation");
        options.addOption(option);
        option = new Option("r", "root", false, "Include root schema declarations");
        options.addOption(option);
        option = new Option("h", "help", false, "This help message");
        options.addOption(option);
        CommandLine cmd = new DefaultParser().parse(options, args);
        if (cmd.hasOption("h")) {
            new HelpFormatter().printHelp("SchemaGenerator [options] ...", options);
            return;
        }
        String xml = new SchemaGenerator(cmd.getOptionValues("p"), cmd.getOptionValues("c"), cmd.getOptionValue("v"), cmd.getOptionValue("t"), cmd.hasOption("r")).toString();
        String string = output = cmd.getArgs().length == 0 ? null : cmd.getArgs()[0];
        if (output == null) {
            System.out.println(xml);
        } else {
            File file = new File(output);
            FileUtils.forceMkdirParent((File)file);
            try (FileOutputStream strm = new FileOutputStream(file);){
                IOUtils.write((String)xml, (OutputStream)strm, (Charset)StandardCharsets.UTF_8);
            }
        }
    }

    public SchemaGenerator(String[] packages, String[] classes, String version, String title, boolean includeRoot) throws Exception {
        Element ele;
        if (!StringUtils.isEmpty((Object)version)) {
            version = new Version(version).toString(Version.VersionPart.MINOR);
            version = StrUtil.piece((String)version, (String)".", (int)1, (int)2);
        }
        ComponentRegistry registry = ComponentRegistry.getInstance();
        if (packages != null) {
            for (String pkg : packages) {
                ComponentScanner.getInstance().scanPackage(pkg);
            }
        }
        if (classes != null) {
            for (String clazz : classes) {
                ComponentScanner.getInstance().scanClass(clazz);
            }
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.schema = docBuilder.newDocument();
        this.root = this.schema.createElementNS(NS_SCHEMA, "xs:schema");
        this.root.setAttribute("targetNamespace", "http://www.fujion.org/schema/fsp");
        this.root.setAttribute("xmlns:fsp", "http://www.fujion.org/schema/fsp");
        this.root.setAttributeNS(NS_VERSIONING, "vc:minVersion", "1.1");
        this.root.setAttribute("elementFormDefault", "qualified");
        this.schema.appendChild(this.root);
        this.createAnnotation(this.root, "Fujion Server Page" + this.formatForTitle(title, ", %s") + this.formatForTitle(version, ", version %s"));
        if (includeRoot) {
            ele = this.createElement("simpleType", this.root, "name", "el");
            ele = this.createElement("restriction", ele, "base", "xs:string");
            this.createElement("pattern", ele, "value", ".*\\$\\{.+\\}.*");
            this.addExtendedType("boolean");
            this.addExtendedType("decimal");
            this.addExtendedType("integer");
            ele = this.createElement("element", this.root, "name", "fsp");
            this.createAnnotation(ele, "Fujion Server Page root tag.");
            ele = this.createElement("complexType", ele, "mixed", "true");
            ele = this.createElement("all", ele);
            ele = this.createElement("any", ele, "namespace", "##targetNamespace");
            ele.setAttribute("notQName", "fsp:fsp");
            this.setCardinality(ele, 0, UNBOUNDED);
            ele = this.createElement("element", this.root, "name", "anyParent");
            ele.setAttribute("abstract", "true");
        } else {
            Assert.isTrue((registry.size() > 0 ? 1 : 0) != 0, (String)"No component annotations found");
            this.createElement("include", this.root, "schemaLocation", "http://www.fujion.org/schema/fsp-root.xsd");
        }
        Iterator iterator = registry.iterator();
        while (iterator.hasNext()) {
            boolean contentAllowed;
            ComponentDefinition def = (ComponentDefinition)iterator.next();
            if (def.getTag().startsWith("#")) continue;
            ele = this.createElement("element", this.root, "name", def.getTag());
            this.createAnnotation(ele, def.getDescription());
            Element ct = this.createElement("complexType", ele);
            if (def.getParentTags().contains("*")) {
                ele.setAttribute("substitutionGroup", "fsp:anyParent");
            }
            boolean childrenAllowed = def.childrenAllowed();
            boolean bl = contentAllowed = def.contentHandling() != Component.ContentHandling.ERROR;
            if (!childrenAllowed && contentAllowed) {
                Element sc = this.createElement("simpleContent", ct);
                ct = this.createElement("extension", sc);
                ct.setAttribute("base", "xs:string");
            } else if (childrenAllowed) {
                if (contentAllowed) {
                    ct.setAttribute("mixed", "true");
                }
                Element childAnchor = this.createElement("all", ct);
                for (Map.Entry<String, ComponentDefinition.Cardinality> childTag : def.getChildTags().entrySet()) {
                    String tag = childTag.getKey();
                    ComponentDefinition.Cardinality card = childTag.getValue();
                    if ("*".equals(tag)) {
                        ele = this.createElement("element", childAnchor, "ref", "fsp:anyParent");
                        this.setCardinality(ele, card);
                        continue;
                    }
                    this.addChildElement(childAnchor, (ComponentDefinition)registry.get(tag), def, card);
                }
            }
            this.processAttributes(def.getSetters(), ct, Component.PropertySetter.class);
            this.processAttributes(def.getFactoryParameters(), ct, Component.FactoryParameter.class);
            this.createElement("anyAttribute", ct, "namespace", "##other").setAttribute("processContents", "lax");
        }
    }

    private String formatForTitle(String value, String format) {
        return StringUtils.isEmpty((Object)value) ? "" : String.format(format, value);
    }

    private void processAttributes(Map<String, Method> setters, Element ct, Class<? extends Annotation> type) {
        for (Map.Entry<String, Method> setter : setters.entrySet()) {
            String defaultValue;
            String key = setter.getKey();
            if (key.startsWith("#") || key.endsWith(":")) continue;
            Element attr = this.createElement("attribute", ct, "name", setter.getKey());
            Method method = setter.getValue();
            Class<?> javaType = method.getParameterTypes()[method.getParameterCount() - 1];
            Annotation annot = method.getAnnotation(type);
            String description = annot instanceof Component.PropertySetter ? ((Component.PropertySetter)annot).description() : ((Component.FactoryParameter)annot).description();
            this.createAnnotation(attr, description);
            if (annot instanceof Component.PropertySetter && !StringUtils.isEmpty((Object)(defaultValue = ((Component.PropertySetter)annot).defaultValue()))) {
                attr.setAttribute("default", defaultValue);
            }
            if (javaType.isEnum()) {
                this.processEnum(attr, javaType);
                continue;
            }
            attr.setAttribute("type", this.getType(javaType));
        }
    }

    private void processEnum(Element attr, Class<?> javaType) {
        String name = this.findElement("element", attr).getAttribute("name") + "_" + attr.getAttribute("name");
        Element root = attr.getOwnerDocument().getDocumentElement();
        attr.setAttribute("type", "fsp:" + name);
        Element st = this.createElement("simpleType", root, "name", name);
        Element union = this.createElement("union", st, "memberTypes", "fsp:el");
        st = this.createElement("simpleType", union);
        Element res = this.createElement("restriction", st);
        res.setAttribute("base", "xs:string");
        for (Object val : javaType.getEnumConstants()) {
            this.createElement("enumeration", res, "value", val.toString().toLowerCase());
        }
    }

    private void addChildElement(Element seq, ComponentDefinition childDef, ComponentDefinition parentDef, ComponentDefinition.Cardinality card) {
        if (childDef.getTag().startsWith("#")) {
            return;
        }
        if (childDef != null && !childDef.isParentTag(parentDef.getTag())) {
            return;
        }
        Element child = this.createElement("element", seq, "ref", "fsp:" + childDef.getTag());
        this.setCardinality(child, card);
    }

    private Element addExtendedType(String type) {
        Element ele = this.createElement("simpleType", this.root, "name", type);
        this.createElement("union", ele, "memberTypes", "xs:" + type + " fsp:el");
        return ele;
    }

    private Element setCardinality(Element ele, ComponentDefinition.Cardinality cardinality) {
        return this.setCardinality(ele, cardinality.getMinimum(), cardinality.hasMaximum() ? Integer.valueOf(cardinality.getMaximum()) : UNBOUNDED);
    }

    private Element setCardinality(Element ele, Object minOccurs, Object maxOccurs) {
        ele.setAttribute("minOccurs", minOccurs.toString());
        ele.setAttribute("maxOccurs", maxOccurs.toString());
        return ele;
    }

    private String getType(Class<?> javaType) {
        String type = null;
        type = type != null ? type : this.getType(javaType, "fsp:boolean", Boolean.TYPE, Boolean.class);
        type = type != null ? type : this.getType(javaType, "fsp:integer", Integer.TYPE, Integer.class);
        type = type != null ? type : this.getType(javaType, "fsp:decimal", Float.TYPE, Float.class, Double.TYPE, Double.class);
        return type != null ? type : "xs:string";
    }

    private String getType(Class<?> javaType, String type, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(javaType)) continue;
            return type;
        }
        return null;
    }

    private Element findElement(String tag, Element ele) {
        tag = "xs:" + tag;
        while (ele != null) {
            if (ele.getTagName().equals(tag)) {
                return ele;
            }
            ele = (Element)ele.getParentNode();
        }
        return null;
    }

    private Element createElement(String tag) {
        return this.schema.createElement("xs:" + tag);
    }

    private Element createElement(String tag, Element parent) {
        return this.createElement(tag, parent, null, null);
    }

    private Element createElement(String tag, Element parent, String keyName, String keyValue) {
        Element element = this.createElement(tag);
        Element ref = null;
        if (keyName != null) {
            element.setAttribute(keyName, keyValue);
        }
        NodeList nodes = parent.getChildNodes();
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            String val;
            Element sib = (Element)nodes.item(i);
            if (!sib.getTagName().endsWith(tag)) continue;
            String string = val = keyName == null ? null : sib.getAttribute(keyName);
            if (val != null && val.compareToIgnoreCase(keyValue) >= 0) {
                ref = sib;
                break;
            }
            ref = (Element)sib.getNextSibling();
        }
        parent.insertBefore(element, ref);
        return element;
    }

    private void createAnnotation(Element ele, String text) {
        if (!StringUtils.isEmpty((Object)text)) {
            Element annotation = this.createElement("annotation", ele);
            this.createElement("documentation", annotation).setTextContent(text);
        }
    }

    public String toString() {
        return XMLUtil.toString((Document)this.schema);
    }
}

