/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.model;

import java.util.function.Function;
import org.fujion.model.IBinding;

public interface IBinder<T> {
    public static final Value NOVALUE = Value.NONE;

    public T getModel();

    public void setModel(T var1);

    default public IBinding read(String modelProperty) {
        return this.read(modelProperty, (Function)null);
    }

    default public IBinding read(String modelProperty, String template) {
        return this.read(modelProperty, new TemplateConverter(template));
    }

    public IBinding read(String var1, Function<?, ?> var2);

    default public IBinding write(String modelProperty) {
        return this.write(modelProperty, (Function)null);
    }

    default public IBinding write(String modelProperty, String template) {
        return this.write(modelProperty, new TemplateConverter(template));
    }

    public IBinding write(String var1, Function<?, ?> var2);

    default public IBinding dual(String modelProperty) {
        return this.dual(modelProperty, (Function)null, (Function)null);
    }

    default public IBinding dual(String modelProperty, String readTemplate, String writeTemplate) {
        return this.dual(modelProperty, new TemplateConverter(readTemplate), new TemplateConverter(writeTemplate));
    }

    public IBinding dual(String var1, Function<?, ?> var2, Function<?, ?> var3);

    public static enum Value {
        NONE;

    }

    public static class TemplateConverter
    implements Function<Object, Object> {
        private final String template;

        TemplateConverter(String template) {
            this.template = template;
        }

        @Override
        public String apply(Object value) {
            return this.template == null || value == null ? null : String.format(this.template, value);
        }
    }
}

