/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.servlet;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.fujion.core.WebUtil;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class MinifiedResourceResolver
extends AbstractResourceResolver {
    private final boolean debugEnabled;
    private final String[] extensions;

    public MinifiedResourceResolver(String ... extensions) {
        this.extensions = extensions;
        this.debugEnabled = WebUtil.isDebugEnabled();
    }

    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        boolean ignore;
        boolean bl = ignore = !FilenameUtils.isExtension((String)requestPath, (String[])this.extensions);
        if (!ignore) {
            int i = requestPath.lastIndexOf(".");
            String ext = this.debugEnabled ? ".src" : ".min";
            String path = requestPath.substring(0, i) + ext + requestPath.substring(i);
            Resource resource = chain.resolveResource(request, path, locations);
            if (resource != null) {
                return resource;
            }
        }
        return chain.resolveResource(request, requestPath, locations);
    }

    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations);
    }
}

