/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.client.ClientInvocation;
import org.fujion.client.ClientRequest;
import org.fujion.client.ExecutionContext;
import org.fujion.common.MiscUtil;
import org.fujion.core.WebUtil;
import org.fujion.websocket.IRequestHandler;
import org.fujion.websocket.Session;
import org.fujion.websocket.Sessions;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

public class WebSocketHandler
extends AbstractWebSocketHandler
implements BeanPostProcessor,
ServletContextAware {
    private static final Log log = LogFactory.getLog(WebSocketHandler.class);
    private static final String ATTR_BUFFER = "message_buffer";
    private static final Map<String, IRequestHandler> handlers = new HashMap<String, IRequestHandler>();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectReader reader = mapper.readerFor(Map.class);
    private static final ObjectWriter writer = mapper.writerFor(Map.class);
    private static final Sessions sessions = Sessions.getInstance();
    private ServletContext servletContext;

    public static void registerRequestHandler(IRequestHandler handler) {
        String type = handler.getRequestType();
        if (handlers.containsKey(type)) {
            throw new RuntimeException("Attempt to register a duplicate request handler for request type: " + type);
        }
        handlers.put(type, handler);
    }

    private static void sendData(WebSocketSession socket, String json) {
        try {
            Session session = WebSocketHandler.resolveSession(socket);
            socket = socket == null ? session.getSocket() : socket;
            socket.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
            session.updateLastActivity();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public static void send(ClientInvocation invocation) {
        WebSocketHandler.send(null, invocation);
    }

    public static void send(WebSocketSession socket, ClientInvocation invocation) {
        try {
            String json = writer.writeValueAsString(invocation.toMap());
            WebSocketHandler.sendData(socket, json);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public static void send(Collection<ClientInvocation> invocations) {
        WebSocketHandler.send(null, invocations);
    }

    public static void send(WebSocketSession socket, Iterable<ClientInvocation> invocations) {
        StringBuilder sb = null;
        Session session = WebSocketHandler.resolveSession(socket);
        try {
            for (ClientInvocation invocation : invocations) {
                sb = sb == null ? new StringBuilder() : sb;
                String json = writer.writeValueAsString(invocation.toMap());
                sb.append(sb.length() == 0 ? "[" : ",").append(json);
                session.notifySessionListeners(invocation);
            }
            if (sb != null) {
                sb.append("]");
                WebSocketHandler.sendData(socket, sb.toString());
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public static void sendError(WebSocketSession socket, Throwable exception) {
        log.error((Object)"Uncaught exception", exception);
        try (StringWriter writer = new StringWriter();
             PrintWriter print = new PrintWriter(writer);){
            exception.printStackTrace(print);
            ClientInvocation invocation = new ClientInvocation((String)null, "fujion.alert", writer.toString(), "Error", "danger");
            WebSocketHandler.send(socket, invocation);
        }
        catch (Exception e) {
            log.error((Object)"Could not send exception to client.", exception);
        }
    }

    private static Session resolveSession(WebSocketSession socket) {
        Session session;
        Session session2 = session = socket == null ? ExecutionContext.getSession() : (Session)socket.getAttributes().get("fujion_session");
        if (session == null) {
            throw new RuntimeException("Request received on unknown socket.");
        }
        return session;
    }

    protected void handleTextMessage(WebSocketSession socket, TextMessage message) {
        Session session = WebSocketHandler.resolveSession(socket);
        Map attribs = socket.getAttributes();
        try {
            StringBuilder buffer = (StringBuilder)attribs.get(ATTR_BUFFER);
            String payload = (String)message.getPayload();
            if (!message.isLast()) {
                if (buffer == null) {
                    buffer = new StringBuilder(payload);
                    attribs.put(ATTR_BUFFER, buffer);
                } else {
                    buffer.append(payload);
                }
                return;
            }
            if (buffer != null) {
                payload = buffer.append(payload).toString();
                buffer = null;
                attribs.remove(ATTR_BUFFER);
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Large payload received from client (" + payload.length() + " bytes)."));
                }
            }
            Map map = (Map)reader.readValue(payload);
            this.processRequest(session, map);
        }
        catch (Exception e) {
            attribs.remove(ATTR_BUFFER);
            log.error((Object)"Error processing client request.", (Throwable)e);
            WebSocketHandler.sendError(socket, e);
        }
    }

    protected void handleBinaryMessage(WebSocketSession socket, BinaryMessage message) throws Exception {
        Session session = WebSocketHandler.resolveSession(socket);
        Map attribs = socket.getAttributes();
        try {
            int b;
            byte[] buffer = (byte[])attribs.get(ATTR_BUFFER);
            byte[] payload = new byte[message.getPayloadLength()];
            ((ByteBuffer)message.getPayload()).get(payload);
            byte[] byArray = buffer = buffer == null ? payload : ArrayUtils.addAll((byte[])buffer, (byte[])payload);
            if (!message.isLast()) {
                attribs.put(ATTR_BUFFER, buffer);
                return;
            }
            if (attribs.remove(ATTR_BUFFER) != null && log.isWarnEnabled()) {
                log.warn((Object)("Large payload received from client (" + buffer.length + " bytes)."));
            }
            ByteArrayInputStream is = new ByteArrayInputStream(buffer);
            byte[] preamble = new byte[100];
            int i = 0;
            while ((b = is.read()) != 10 && b != -1) {
                if (i >= preamble.length) {
                    preamble = Arrays.copyOf(preamble, i + 100);
                }
                preamble[i++] = (byte)b;
            }
            Map map = (Map)reader.readValue(preamble, 0, i);
            Map data = (Map)map.get("data");
            data.put("blob", is);
            this.processRequest(session, map);
        }
        catch (Exception e) {
            attribs.remove(ATTR_BUFFER);
            log.error((Object)"Error processing client request.", (Throwable)e);
            WebSocketHandler.sendError(socket, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(Session session, Map<String, Object> map) throws Exception {
        session._init((String)map.get("pid"));
        session.updateLastActivity();
        ClientRequest request = new ClientRequest(session, map);
        IRequestHandler handler = handlers.get(request.getType());
        if (handler == null) {
            throw new IllegalArgumentException("No registered handler for request type: " + request.getType());
        }
        ExecutionContext.clear();
        ExecutionContext.put("fujion_request", request);
        try {
            handler.handleRequest(request);
            session.notifySessionListeners(request);
            request.getPage().getEventQueue().processAll();
        }
        catch (Exception e) {
            request.getPage().getEventQueue().clearAll();
            log.error((Object)e);
            WebSocketHandler.sendError(session.getSocket(), e);
        }
        finally {
            ExecutionContext.clear();
        }
    }

    public void afterConnectionEstablished(WebSocketSession socket) throws Exception {
        sessions.createSession(this.servletContext, socket);
    }

    public void afterConnectionClosed(WebSocketSession socket, CloseStatus status) throws Exception {
        sessions.destroySession(socket, status);
    }

    public boolean supportsPartialMessages() {
        return true;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof IRequestHandler) {
            WebSocketHandler.registerRequestHandler((IRequestHandler)bean);
        }
        return bean;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        WebUtil.initDebug(servletContext);
    }
}

