/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseUIComponent;
import org.fujion.component.Row;
import org.fujion.model.IModelAndView;
import org.fujion.model.ISupportsModel;
import org.fujion.model.ModelAndView;

@Component(tag="rows", widgetModule="fujion-grid", widgetClass="Rows", parentTag={"grid"}, childTag={@Component.ChildTag(value="row")}, description="A container for a grid's rows.")
public class Rows
extends BaseUIComponent
implements ISupportsModel<Row> {
    private Selectable selectable = Selectable.NO;
    private final Set<Row> selected = new LinkedHashSet<Row>();
    private final ModelAndView<Row, Object> modelAndView = new ModelAndView(this);

    @Override
    public void destroy() {
        super.destroy();
        this.modelAndView.destroy();
    }

    @Override
    public IModelAndView<Row, ?> getModelAndView() {
        return this.modelAndView;
    }

    @Component.PropertyGetter(value="selectable", description="The selectability setting.")
    public Selectable getSelectable() {
        return this.selectable;
    }

    @Component.PropertySetter(value="selectable", defaultValue="no", description="The selectability setting.")
    public void setSelectable(Selectable selectable) {
        this.selectable = this.defaultify(selectable, Selectable.NO);
        if (this.propertyChange("selectable", (Object)this.selectable, (Object)this.selectable, true) && selectable != Selectable.MULTIPLE && !this.selected.isEmpty()) {
            this.unselect(selectable == Selectable.NO ? null : this.getSelectedRow());
        }
    }

    public Row getSelectedRow() {
        return this.selected.isEmpty() ? null : this.selected.iterator().next();
    }

    public Set<Row> getSelected() {
        return Collections.unmodifiableSet(this.selected);
    }

    public void clearSelected() {
        this.unselect(null);
    }

    private void unselect(Row excluded) {
        Iterator<Row> iter = this.selected.iterator();
        while (iter.hasNext()) {
            Row row = iter.next();
            if (row == excluded) continue;
            row._setSelected(false, true, false);
            iter.remove();
        }
    }

    public int getSelectedCount() {
        return this.selected.size();
    }

    protected void _updateSelected(Row row) {
        if (row.isSelected()) {
            this.selected.add(row);
            if (this.selectable != Selectable.MULTIPLE) {
                this.unselect(this.selectable == Selectable.NO ? null : row);
            }
        } else {
            this.selected.remove(row);
        }
    }

    @Override
    protected void afterRemoveChild(BaseComponent child) {
        super.afterRemoveChild(child);
        this.selected.remove(child);
    }

    @Override
    protected void afterAddChild(BaseComponent child) {
        super.afterAddChild(child);
        Row row = (Row)child;
        if (row.isSelected()) {
            this._updateSelected(row);
        }
    }

    public static enum Selectable {
        NO,
        SINGLE,
        MULTIPLE;

    }
}

