/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.core;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.fujion.client.ExecutionContext;
import org.fujion.common.MiscUtil;
import org.fujion.common.StrUtil;
import org.fujion.core.RequestUtil;
import org.fujion.servlet.WebAppConfiguration;
import org.fujion.webjar.WebJarResourceResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class WebUtil {
    public static final String FUJION_VERSION = WebUtil.class.getPackage().getImplementationVersion();

    public static boolean isDebugEnabled() {
        return WebAppConfiguration.isDebugEnabled();
    }

    public static Map<String, String> queryStringToMap(String queryString) {
        return WebUtil.queryStringToMap(queryString, ",");
    }

    public static Map<String, String> queryStringToMap(String queryString, String valueDelimiter) {
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        try {
            valueDelimiter = valueDelimiter == null ? "" : valueDelimiter;
            URI uri = new URI(queryString.startsWith("?") ? queryString : "?" + queryString);
            List params = URLEncodedUtils.parse((URI)uri, (Charset)StrUtil.UTF8);
            HashMap<String, String> result = new HashMap<String, String>();
            for (NameValuePair nvp : params) {
                String value = (String)result.get(nvp.getName());
                result.put(nvp.getName(), (value == null ? "" : value + valueDelimiter) + nvp.getValue());
            }
            return result;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String addQueryString(String url, String queryString) {
        Validate.notNull((Object)url, (String)"The url must not be null");
        if (!StringUtils.isEmpty((String)queryString)) {
            url = url.endsWith("?") ? url + queryString : (url.contains("?") ? url + "&" + queryString : url + "?" + queryString);
        }
        return url;
    }

    public static String getQueryParams() {
        String requestUrl = WebUtil.getRequestUrl();
        int i = requestUrl == null ? -1 : requestUrl.indexOf("?");
        return i == -1 ? "" : requestUrl.substring(i + 1);
    }

    public static String getRequestUrl() {
        return ExecutionContext.getPage().getBrowserInfo("requestURL");
    }

    public static String getBaseUrl() {
        String url = WebUtil.getRequestUrl();
        String path = ExecutionContext.getServletContext().getContextPath();
        int i = url.indexOf(path);
        return url.substring(0, i + path.length()) + "/";
    }

    public static Cookie getCookie(String cookieName) {
        return WebUtil.getCookie(cookieName, RequestUtil.getRequest());
    }

    public static Cookie getCookie(String cookieName, HttpServletRequest httpRequest) {
        Validate.notNull((Object)cookieName, (String)"The cookieName must not be null");
        Validate.notNull((Object)httpRequest, (String)"The httpRequest must not be null");
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : httpRequest.getCookies()) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String getCookieValue(String cookieName) {
        return WebUtil.getCookieValue(cookieName, RequestUtil.getRequest());
    }

    public static String getCookieValue(String cookieName, HttpServletRequest httpRequest) {
        Cookie cookie = WebUtil.getCookie(cookieName, httpRequest);
        return cookie == null ? null : WebUtil.decodeCookieValue(cookie.getValue());
    }

    public static String encodeCookieValue(String cookieValuePlainText) {
        Validate.notNull((Object)cookieValuePlainText, (String)"The cookieValuePlainText must not be null");
        try {
            return URLEncoder.encode(Base64.encodeBase64String((byte[])cookieValuePlainText.getBytes()), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception occurred encoding cookie value", e);
        }
    }

    public static String decodeCookieValue(String encodedCookieValue) {
        Validate.notNull((Object)encodedCookieValue, (String)"The encodedCookieValue must not be null");
        try {
            return new String(Base64.decodeBase64((String)URLDecoder.decode(encodedCookieValue, "UTF-8")));
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception occurred decoding cookie value", e);
        }
    }

    public static Cookie setCookie(String cookieName, String value, HttpServletResponse httpResponse, HttpServletRequest httpRequest) {
        Validate.notNull((Object)httpResponse, (String)"The httpResponse must not be null");
        Cookie cookie = WebUtil.getCookie(cookieName, httpRequest);
        if (value != null) {
            value = WebUtil.encodeCookieValue(value);
        }
        if (cookie == null) {
            if (value == null) {
                return null;
            }
            cookie = new Cookie(cookieName, value);
        } else if (value == null) {
            cookie.setMaxAge(0);
        } else {
            cookie.setValue(value);
        }
        if (httpRequest.isSecure()) {
            cookie.setSecure(true);
        }
        httpResponse.addCookie(cookie);
        return cookie;
    }

    public static Resource getResource(String src) {
        try {
            ClassPathResource resource;
            if (src.startsWith("web/") || src.startsWith("/web/")) {
                resource = new ClassPathResource(src);
            } else if (src.matches("^.*\\:\\/.*")) {
                resource = new UrlResource(src);
            } else {
                ServletContext ctx;
                URL url;
                String string = src = src.startsWith("/") ? src : "/" + src;
                if (src.startsWith("/webjars/")) {
                    src = "/webjars/" + WebJarResourceResolver.getResourcePath(src.substring(9));
                }
                UrlResource urlResource = resource = (url = (ctx = ExecutionContext.getSession().getServletContext()).getResource(src)) == null ? null : new UrlResource(url);
            }
            if (resource == null || !resource.exists()) {
                throw new FileNotFoundException(src);
            }
            return resource;
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    private WebUtil() {
    }
}

