/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.event;

import java.util.HashMap;
import java.util.Map;
import org.fujion.event.Event;
import org.fujion.event.EventListenerSet;
import org.fujion.event.IEventListener;

public class EventListeners {
    private final Map<String, EventListenerSet> allListeners = new HashMap<String, EventListenerSet>();

    public void add(String eventType, IEventListener eventListener) {
        this.getListeners(eventType, true).add(eventListener);
    }

    public void remove(String eventType, IEventListener eventListener) {
        EventListenerSet listeners = this.getListeners(eventType, false);
        if (listeners != null) {
            listeners.remove(eventListener);
            if (listeners.isEmpty()) {
                this.allListeners.remove(eventType);
            }
        }
    }

    public void removeAll() {
        this.allListeners.clear();
    }

    public void removeAll(String eventType) {
        this.allListeners.remove(eventType);
    }

    public void invoke(Event event) {
        EventListenerSet listeners = this.getListeners(event.getType(), false);
        if (listeners != null) {
            listeners.onEvent(event);
        }
    }

    public boolean hasListeners(String eventType) {
        EventListenerSet listeners = this.getListeners(eventType, false);
        return listeners != null && !listeners.isEmpty();
    }

    private EventListenerSet getListeners(String eventType, boolean forceCreate) {
        EventListenerSet listeners = this.allListeners.get(eventType);
        if (listeners == null && forceCreate) {
            listeners = new EventListenerSet();
            this.allListeners.put(eventType, listeners);
        }
        return listeners;
    }
}

