/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.expression;

import org.fujion.expression.ContextAccessor;
import org.fujion.expression.ELMethodResolver;
import org.fujion.expression.MessageAccessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;

public class ELEvaluator
extends StandardEvaluationContext
implements BeanPostProcessor,
ApplicationContextAware {
    private static final ELEvaluator instance = new ELEvaluator();
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final ParserContext templateContext = new TemplateParserContext("${", "}");
    private final DefaultConversionService conversionService = new DefaultConversionService();

    public static ELEvaluator getInstance() {
        return instance;
    }

    private ELEvaluator() {
        this.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
        this.addPropertyAccessor(new MessageAccessor());
        this.addPropertyAccessor(new ContextAccessor());
        this.addMethodResolver((MethodResolver)new ELMethodResolver());
        this.conversionService.addConverter((Converter)new MessageAccessor.MessageContextConverter());
        this.setTypeConverter((TypeConverter)new StandardTypeConverter((ConversionService)this.conversionService));
    }

    public Object evaluate(String expression, Object root) {
        Object value = this.parseExpression(expression).getValue((EvaluationContext)this, root);
        return value instanceof MessageAccessor.MessageContext ? value.toString() : value;
    }

    public Object evaluate(String expression) {
        return this.parseExpression(expression).getValue((EvaluationContext)this);
    }

    private Expression parseExpression(String expression) {
        return this.parser.parseExpression(expression, this.templateContext);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ConstructorResolver) {
            this.addConstructorResolver((ConstructorResolver)bean);
        } else if (bean instanceof MethodResolver) {
            this.addMethodResolver((MethodResolver)bean);
        } else if (bean instanceof PropertyAccessor) {
            this.addPropertyAccessor((PropertyAccessor)bean);
        } else if (bean instanceof Converter) {
            this.conversionService.addConverter((Converter)bean);
        } else if (bean instanceof BeanResolver) {
            this.setBeanResolver((BeanResolver)bean);
        }
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.setRootObject(applicationContext.getEnvironment());
        this.setBeanResolver((context, beanName) -> applicationContext.getBean(beanName));
    }
}

