/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

public abstract class AbstractScope
implements Scope {
    private static final Log log = LogFactory.getLog(AbstractScope.class);

    public abstract ScopeContainer getContainer();

    public Object get(String name, ObjectFactory<?> objectFactory) {
        return this.getContainer().get(name, objectFactory);
    }

    public Object remove(String name) {
        return this.getContainer().remove(name);
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        this.getContainer().registerDestructionCallback(name, callback);
    }

    public Object resolveContextualObject(String key) {
        return this.getContainer().resolveContextualObject(key);
    }

    public String getConversationId() {
        ScopeContainer container = this.getContainer();
        return container == null ? null : container.getConversationId();
    }

    public static class ScopeContainer
    implements Scope {
        private final Map<String, Object> beans = new HashMap<String, Object>();
        private final Map<String, Runnable> destructionCallbacks = new HashMap<String, Runnable>();
        private final String conversationId;

        public ScopeContainer(String conversationId) {
            this.conversationId = conversationId;
        }

        public synchronized Object remove(String key) {
            this.destructionCallbacks.remove(key);
            return this.beans.remove(key);
        }

        public synchronized Object get(String name, ObjectFactory<?> objectFactory) {
            Object bean = this.beans.get(name);
            if (bean == null) {
                bean = objectFactory.getObject();
                this.beans.put(name, bean);
            }
            return bean;
        }

        public synchronized void registerDestructionCallback(String name, Runnable callback) {
            this.destructionCallbacks.put(name, callback);
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        public void destroy() {
            for (Map.Entry<String, Runnable> entry : this.destructionCallbacks.entrySet()) {
                try {
                    entry.getValue().run();
                }
                catch (Throwable t) {
                    log.error((Object)("Error during destruction callback for bean " + entry.getKey()), t);
                }
            }
            this.beans.clear();
            this.destructionCallbacks.clear();
        }

        public Object resolveContextualObject(String key) {
            return null;
        }

        public String getConversationId() {
            return this.conversationId;
        }
    }
}

