/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.spring;

import org.fujion.client.ExecutionContext;
import org.fujion.spring.AbstractScope;
import org.fujion.websocket.ISessionLifecycle;
import org.fujion.websocket.Session;
import org.fujion.websocket.Sessions;

public class PageScope
extends AbstractScope {
    private static final String SCOPE_ATTR = PageScope.class.getName();
    private final ISessionLifecycle sessionTracker = new ISessionLifecycle(){

        @Override
        public void onSessionCreate(Session session) {
            AbstractScope.ScopeContainer scopeContainer = new AbstractScope.ScopeContainer(session.getId());
            session.getAttributes().put(SCOPE_ATTR, scopeContainer);
        }

        @Override
        public void onSessionDestroy(Session session) {
            AbstractScope.ScopeContainer container = (AbstractScope.ScopeContainer)session.getAttributes().remove(SCOPE_ATTR);
            if (container != null) {
                container.destroy();
            }
        }
    };

    public PageScope() {
        Sessions.getInstance().addLifecycleListener(this.sessionTracker);
    }

    @Override
    public AbstractScope.ScopeContainer getContainer() {
        Session session = ExecutionContext.getSession();
        if (session == null) {
            throw new IllegalStateException("Cannot access Page scope outside of an execution context.");
        }
        return (AbstractScope.ScopeContainer)session.getAttributes().get(SCOPE_ATTR);
    }
}

