/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.theme;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Theme {
    private static final Log log = LogFactory.getLog(Theme.class);
    private final String name;
    private final Map<String, Mapping> urlMap = new LinkedHashMap<String, Mapping>();

    public Theme(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void merge(Theme theme) {
        Map<String, Mapping> srcMap = theme.urlMap;
        for (String pattern : srcMap.keySet()) {
            this.dupCheck(pattern);
            this.urlMap.put(pattern, srcMap.get(pattern));
        }
    }

    public void setMappings(Map<String, String> mappings) {
        for (String fromPattern : mappings.keySet()) {
            this.addMapping(fromPattern, mappings.get(fromPattern));
        }
    }

    public void addMapping(String fromPattern, String toPattern) {
        this.dupCheck(fromPattern);
        this.urlMap.put(fromPattern, new Mapping(fromPattern, toPattern));
    }

    private void dupCheck(String pattern) {
        if (log.isWarnEnabled() && this.urlMap.containsKey(pattern)) {
            log.warn((Object)String.format("Overwriting URL pattern \"%s\" in theme \"%s\"", pattern, this.name));
        }
    }

    public String translatePath(String path) {
        for (Mapping mapping : this.urlMap.values()) {
            String newPath = mapping.translate(path);
            if (newPath == null) continue;
            return newPath;
        }
        return null;
    }

    private class Mapping {
        final Pattern fromPattern;
        final String toPattern;

        Mapping(String fromPattern, String toPattern) {
            this.fromPattern = this.toRegEx(fromPattern);
            this.toPattern = StringUtils.trimToNull((String)toPattern);
        }

        Pattern toRegEx(String pattern) {
            if (pattern.startsWith("^")) {
                return Pattern.compile(pattern);
            }
            StringBuilder regex = new StringBuilder("^");
            int last = pattern.length() - 1;
            String literal = "";
            block4: for (int i = 0; i <= last; ++i) {
                char c = pattern.charAt(i);
                String token = "";
                switch (c) {
                    case '*': {
                        if (i < last && pattern.charAt(i + 1) == '*') {
                            ++i;
                            token = "(.*)";
                            break;
                        }
                        token = "(.?\\/)";
                        break;
                    }
                    case '?': {
                        token = "(.)";
                        break;
                    }
                    default: {
                        literal = literal + c;
                        if (i < last) continue block4;
                    }
                }
                if (!literal.isEmpty()) {
                    regex.append("\\Q").append(literal).append("\\E");
                    literal = "";
                }
                regex.append(token);
            }
            return Pattern.compile(regex.append('$').toString());
        }

        String translate(String path) {
            Matcher from = this.fromPattern.matcher(path);
            if (from.matches()) {
                return this.toPattern == null ? "" : from.replaceAll(this.toPattern.replace("$0", Theme.this.name));
            }
            return null;
        }
    }
}

