/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.webjar;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.fujion.common.MiscUtil;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class WebJar {
    private static final String[] EXTENSIONS = new String[]{"", ".js", ".css"};
    private final Resource resource;
    private final String name;
    private final String version;
    private final String absolutePath;
    private ObjectNode config;

    public WebJar(Resource resource) {
        try {
            this.resource = resource;
            this.absolutePath = resource.getURL().toString();
            int i = this.absolutePath.lastIndexOf("/webjars/") + 9;
            int j = this.absolutePath.indexOf("/", i);
            this.name = this.absolutePath.substring(i, j);
            i = this.absolutePath.indexOf("/", j + 1);
            this.version = this.absolutePath.substring(j + 1, i);
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    protected ObjectNode getConfig() {
        if (this.config != null) {
            this.normalizePaths();
            this.normalizePackages();
        }
        return this.config;
    }

    protected void setConfig(ObjectNode config) {
        this.config = config;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getRootPath() {
        return "webjars/" + this.name + "/";
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Resource createRelative(String relativePath) {
        try {
            return this.resource.createRelative(relativePath);
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public Resource findResource(ResourcePatternResolver resourceLoader, String ... extensions) {
        try {
            String path = this.getRootPath();
            for (String extension : extensions) {
                Resource[] resources = resourceLoader.getResources(path + "**/*." + extension);
                if (resources.length <= 0) continue;
                return resources[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "webjar:" + this.name + ":" + this.version;
    }

    private void normalizePaths() {
        this.normalizePaths("paths");
        this.normalizePaths("map");
    }

    private void normalizePaths(String node) {
        ObjectNode paths = (ObjectNode)this.config.get(node);
        if (paths != null) {
            Iterator iter = paths.fields();
            while (iter.hasNext()) {
                String value;
                Map.Entry entry = (Map.Entry)iter.next();
                JsonNode child = (JsonNode)entry.getValue();
                if (!child.isTextual() || (value = child.asText()).contains("webjars/")) continue;
                entry.setValue(this.createPathNode(value));
            }
        }
    }

    private void normalizePackages() {
        JsonNode packages = this.config.get("packages");
        if (packages != null && packages.isArray()) {
            this.config.remove("packages");
            ObjectNode pkgs = this.config.objectNode();
            this.config.set("packages", (JsonNode)pkgs);
            for (int i = 0; i < packages.size(); ++i) {
                this.fixPackage(packages.get(i), pkgs);
            }
        }
    }

    private void fixPackage(JsonNode entry, ObjectNode pkgs) {
        String name;
        String main = null;
        ObjectNode pkg = pkgs.objectNode();
        if (entry.isTextual()) {
            name = entry.asText();
            main = "main";
        } else {
            JsonNode mainNode = entry.get("main");
            main = mainNode == null ? null : mainNode.asText();
            JsonNode nameNode = entry.get("name");
            String string = name = nameNode == null ? null : nameNode.asText();
        }
        if (name != null) {
            pkg.set("main", (JsonNode)new TextNode(main == null ? "main" : main));
            pkg.set("defaultExtension", (JsonNode)new TextNode("js"));
            pkgs.set(name, (JsonNode)pkg);
            this.getOrCreateMapNode().set(name, (JsonNode)this.createPathNode(""));
        }
    }

    private ObjectNode getOrCreateMapNode() {
        ObjectNode map = (ObjectNode)this.config.get("map");
        if (map == null) {
            map = this.config.objectNode();
            this.config.set("map", (JsonNode)map);
        }
        return map;
    }

    private TextNode createPathNode(String file) {
        for (String ext : EXTENSIONS) {
            Resource resource = this.createRelative(file + ext);
            if (!resource.exists() || !resource.isReadable()) continue;
            file = file + ext;
            break;
        }
        return new TextNode(this.getRootPath() + file);
    }
}

